<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class SectorDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'name',
        'sector_id',
        'language_id',
    ];

    /**
     * @return BelongsTo
     */
    public function state() :BelongsTo
    {
        return $this->belongsTo(Sector::class);
    }
}
