<?php

namespace App;

use App\Helpers\ImageHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class Sector extends Model
{
    // Fields that mass assignment
    protected $fillable = ['city_id'];

    // Use soft delete
    use SoftDeletes;

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(SectorDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(SectorDescription::class)->where('language_id', currentLanguage()->id);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public static function withDescription($city_id = null, $sector_id = null)
    {
        $sectors = self::join('sector_descriptions as sd', 'sd.sector_id', 'sectors.id')
            ->where('sd.language_id', currentLanguage()->id);

        if($city_id){
            $sectors->where('sectors.city_id', $city_id);
        }

        if ($sector_id){
            $sectors->where('sectors.id', $sector_id);
        }

        $sectors->select([
            'sectors.*',
            'sd.name',
        ]);
        return $sector_id ? $sectors->first() : $sectors->cursor() ?? [];
    }

}
