<?php

namespace App;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

/**
 * @property mixed added_services
 * @property mixed services
 * @property mixed re_days
 * @mixin Builder
 */
class Reservation extends Model
{
    use SoftDeletes;

    protected $fillable = [
        're_no',
        're_status',
        're_way',
        'is_paid',
        'services',
        'added_services',
        'person_count',
        'reservation_type',
        'booking_amount_per_person',
        'booking_amount_per_day',
        'invitation_count',
        'invitations',
        'net_total',
        'total',
        'other_details',
        'added_value_amount',
        're_days',
        're_date_from',
        're_date_to',
        'is_evaluate',
        'user_id',
        'provider_id',
        'hall_id',
        'occasion_id',
        'canceled_from',
    ];

    protected $casts = [
        'services' => 'array',
        'added_services' => 'array',
        'invitations' => 'array',
        're_days' => 'array',
    ];

    public function hall()
    {
        return $this->belongsTo(Hall::class);
    }

    public function provider()
    {
        return $this->belongsTo(User::class)->where('users.role', '=', 'provider');
    }

    public function user()
    {
        return $this->belongsTo(User::class)->where('users.role', '=', 'user');
    }

    public static function userReservations($status = null, $dateFrom = null, $dateTo = null, $reNo = null, $userId = null, $reservationId = null, $isPaid = null, $providerId = null)
    {
        $languageId = currentLanguage()->id;
        $date = date('Y-m-d');

        $reservations = self::orderByDesc('reservations.id')
        ->whereNotNull('reservations.re_status');

        if ($userId){
            $reservations->where('reservations.user_id', $userId);
        }

        if ($providerId){
            $reservations->where('reservations.provider_id', $providerId);
        }

        if ($reservationId){
            $reservations->where('reservations.id', $reservationId);
        }

        if ($status && $status == 'daily'){
            $reservations->where('reservations.re_date_from', '<=', $date)
                ->where('reservations.re_date_to', '>=', $date)
                ->where('reservations.re_status', 'confirmed');
        }

        if ($status){
            $reservations->where('reservations.re_status', $status);
        }


//        if ($dateFrom){
//            $reservations->where('reservations.re_date_from', $dateFrom);
//        }
//        if ($dateTo){
//            $reservations->where('reservations.re_date_to', $dateTo);
//        }
        if ($dateFrom){
            $reservations->where('reservations.created_at', '>=',  $dateFrom);
        }
        if ($dateTo){
            $reservations->where('reservations.created_at', '<=', $dateTo);
        }
        if ($reNo){
//            $reservations->where('reservations.re_no', 'LIKE', '%'.$reNo.'%');
            $reservations->where('reservations.re_no', $reNo);
        }
        if ($isPaid == 'paid'){
            $reservations->where('reservations.is_paid', 1);
        }
        if ($isPaid == 'not_paid'){
            $reservations->where('reservations.is_paid', 0);
        }

        $reservations->join('halls', 'reservations.hall_id', 'halls.id')
            ->join('hall_descriptions as hall_desc', 'hall_desc.hall_id', 'halls.id')
            ->where('hall_desc.language_id', $languageId)
            ->join('users as providers', 'providers.id', 'reservations.provider_id')
            ->join('users', 'users.id', 'reservations.user_id')
            ->join('categories', 'categories.id', 'halls.category_id')
            ->join('category_descriptions as cat_desc', 'categories.id', 'cat_desc.category_id')
            ->where('cat_desc.language_id', $languageId)
            ->select(
                [
                    'reservations.id',
                    'reservations.hall_id',
                    'reservations.is_evaluate',
                    'reservations.other_details',
                    'halls.reservation_way',
                    'halls.reservation_type',
                    'halls.booking_amount_per_day',
                    'halls.booking_amount_per_person',
                    'halls.capacity',
                    'halls.total_capacity',
                    'halls.min_capacity',
                    'halls.booking_amount_per_person',
                    'halls.lat',
                    'halls.lng',
                    'halls.street',
                    'halls.added_services as hall_added_service',
                    'halls.images',
                    'halls.available_dates',
                    'reservations.re_no',
                    'reservations.re_status',
                    'reservations.re_way',
                    'reservations.re_days',
                    'reservations.services',
                    'reservations.added_services as reserve_added_service',
                    'reservations.person_count',
                    'reservations.net_total',
                    'reservations.total',
                    'reservations.added_value_amount',
                    'reservations.re_date_from',
                    'reservations.re_date_to',
                    'reservations.canceled_from',
                    'reservations.invitation_count',
                    'reservations.invitations',
                    'reservations.canceled_from',
                    'providers.id as provider_id',
                    'providers.name as provider_name',
                    'providers.phone as provider_phone',
                    'providers.email as provider_email',
                    'providers.photo as provider_photo',
                    'cat_desc.name as category_name',
                    'hall_desc.name as hall_name',
                    'users.id as client_id',
                    'users.name as client_name',
                    'users.phone as client_phone',
                    'users.email as client_email',
                    'reservations.created_at',
                ]
            );
//            ->join('occasions', 'occasions.id', 'reservations.occasion_id')
//            ->join('occasion_descriptions as od', 'occasions.id', 'od.occasion_id')


        return ($reservationId)? $reservations->first()  : $reservations->get() ?? [];

    }
}
