<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class RegionDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'name',
        'region_id',
        'language_id',
    ];

    /**
     * @return BelongsTo
     */
    public function state() :BelongsTo
    {
        return $this->belongsTo(Region::class);
    }
}
