<?php

namespace App\Providers;

use App\Module;
use App\Setting;
use App\Language;
use App\Page;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Schema;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class AppServiceProvider extends ServiceProvider
{
    protected static $meta = null;

    /**
     * Register any application services.
     *
     * @return void
     */

    /**
     * @return null
     */
    public static function getMeta()
    {
        return self::$meta;
    }

    public function register()
    {

    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        date_default_timezone_set('Asia/Riyadh');
        // Fix migrate issue associated with index key length
        Schema::defaultStringLength(191);

        // CMS Supported Languages
        $languages= Language::where('status', 1)->cursor();
        View::share('languages', $languages);

        View::composer('*', function($view) {
            // Current Lang
            $view->with('lang', LaravelLocalization::getCurrentLocale());

            $isNotAdminRoute= request()->route() ? (strpos(request()->route()->getPrefix(), 'admin') === false) : true;
            $routePath= $this->app->request->getRequestUri();
            $routePath= explode('/', trim($routePath, '/'));
            // dd($isNotAdminRoute, count($routePath), request()->path());

            $activeMenu= [];
            if (!$isNotAdminRoute) {
                if ('admin' == $routePath[0] ) {
                    // dd($routePath);
                    $activeMenu[$routePath[1] ?? ""]= 'active';
                    $view->with('activeMenu', $activeMenu);
                }elseif ( isset($routePath[1]) && 'admin' == $routePath[1] ) {
                    $activeMenu[$routePath[2] ?? ""]= 'active';
                    $view->with('activeMenu', $activeMenu);
                }
            } else {
                // Web

                // Main Info
                $settings = settings([
                    'website_logo',
                    'website_name',
                    'keywords',
                    'meta_description',
                    'site_email',
                    'site_address',
                    'site_phone',
                    'facebook',
                    'twitter',
                    'instagram',
                    'whatsapp',
                    'visa_master',
                    'apple_pay',
                    'stc_pay',
                    'mada',
                    'contact_us_image',
                    'added_value',
                    'tax_number',
                    'website_percentage',
                ]);
                $view->with('settings', $settings);

                // Navigation Data

                // About Us Page Route
//                $aboutUs= Page::where('id', 1)->first();
//                $view->with('aboutUs', $aboutUs);

                // Portfolio Route
//                $portfolio= WebsiteCategory::where('id', 2)->first();
//                $view->with('portfolio', $portfolio ?? null);

                // Latest News Route
//                $latestNews= Category::where('id', 1)->first();
//                $view->with('latestNews', $latestNews ?? null);

                // Gallery Route
//                $gallery= PhotoCategory::where('id', 1)->first();
//                $view->with('gallery', $gallery ?? null);

                // Gallery Route
//                $videoGallery= VideoCategory::where('id', 1)->first();
//                $view->with('videoGallery', $videoGallery ?? null);
            }

            // Current User Info
            $userInfo= (object) ['photo'=> 'uploads/avatar.png'];
            if(Auth::check()){
                $userInfo= Auth::user()->whereIn('role', ['super_admin', 'admin', 'sub_admin'])->first();
                if (!is_file(public_path($userInfo->photo))) {
                    $userInfo->photo= 'uploads/avatar.png';
                }

                // Get Modules Current User can access
                if (in_array($userInfo->role, ['super_admin', 'admin']) || $userInfo->admin_token) {
                    $userInfo->modules = Module::where('deleted_at', null)->cursor();
                }

                if ($userInfo->role == 'sub_admin') {
                    $userInfo->modules = Module::where('deleted_at', null)
                        ->join('user_modules as um', 'um.module_id', 'modules.id')
                        ->where('um.user_id', $userInfo->id)
                        ->select(['modules.*', 'um.*'])->cursor();
                }

            }
            $view->with('currentUserInfo', $userInfo);

            // Share meta for modules instead of language files
            if (Schema::hasTable('modules')){

                if (preg_match('/admin/', URL::current())){
                    $path = explode('.', Route::currentRouteName());
                    if (preg_match('/_/', $path[0])){
                        $path = explode('_', $path[0]);
                        $path = $path[0].ucfirst($path[0]);
                    } else {
                        $path = $path[0];
                    }

                    $module = Module::where('path', $path)->pluck('meta')->toArray();
                    $meta = array_first($module);
                    static::$meta = $meta;
                    $view->with('meta', $meta);
                }
            }

        });

        // Email configuration Got from settings

        if (Schema::hasTable('settings')){
            $settings = Setting::cursor();
            if(count($settings) > 0){
                foreach ($settings as $setting) {
                    $settings->{$setting['key']} = $setting['value'];
                }

                /**
                Config::set('app.name', $settings->website_name);
                Config::set('mail.name', $settings->website_name);
//                Config::set('mail.driver',$settings->mail_driver);
//                Config::set('mail.host',$settings->mail_host);
//                Config::set('mail.port',$settings->mail_port);
//                Config::set('mail.username',$settings->mail_username);
//                Config::set('mail.password',$settings->mail_password);
                Config::set('mail.from', [
                    'address' => $settings->mail_from_address,
                    'name' => $settings->mail_from_name,
                ]); */


                Config::set('app.name', $settings->website_name);
                Config::set('mail.name', $settings->website_name);
                $config = [
                    // 'driver'     => 'sendmail',
                    'driver'     => $settings->mail_driver ?? 'sendmail',
                    'from'       => array('address' => $settings->mail_from_address, 'name' => $settings->mail_from_name),
                    'encryption' => $settings->mail_encryption,
                    'port'       => $settings->mail_port,
                    "path" => "/usr/sbin/sendmail -bs"
                ];
                if('smtp' == $settings->mail_driver){
                    $config=array_merge( $config, [
                        'host'       => $settings->mail_host,
                        'username'   => $settings->mail_username,
                        'password'   => $settings->mail_password,
                        'ssl' => array(
                            'verify_peer' => false,
                            'verify_peer_name' => false,
                            'allow_self_signed' => true
                        )
                    ]);
                }
                // dd($config);
                Config::set('mail', $config);
//
            }

            $logo = $settings->where('key', 'website_logo')->first();
            if ($logo){
                view()->share('logo', $logo->value);
            }
        }
    }
}
