<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Policy extends Model
{
    use SoftDeletes;

    public static function withDescription($id = null)
    {
        $language_id = currentLanguage()->id;
        $policies = self::join('policy_descriptions as pd', 'pd.policy_id', 'policies.id')
            ->where('pd.language_id', $language_id);
            if ($id){
                $policies->where('policies.id', $id);
            }
        $policies->select([
            'policies.*',
            'pd.terms_conditions_description',
            'pd.privacy_policy_description',
            'pd.privacy_policy_description_list'
        ]);

        return $policies->first();
    }
}
