<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class PartnerDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'name',
        'slug',
        'meta_description',
        'keywords',
        'description',
        'partner_id',
        'language_id',
    ];

    /**
     * @return BelongsTo
     */
    public function partner() :BelongsTo
    {
        return $this->belongsTo(Partner::class);
    }
}
