<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Partner extends Model
{
    // Fields that mass assignment
    protected $fillable = ['image'];

    // Use soft delete
    use SoftDeletes;

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(PartnerDescription::class);
    }

    public static function withDescription()
    {
        return self::join('partner_descriptions as pd', 'pd.partner_id', 'partners.id')
            ->where('pd.language_id', currentLanguage()->id)
            ->select(['pd.name', 'pd.description', 'partners.*'])->cursor() ?? [];
    }
}
