<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class Occasion extends Model
{
    // For soft delete
    use SoftDeletes;

    protected $fillable = ['image'];


    public static function withDescription($occasionsId = null, $categoryId = null)
    {
        $occasions = self::join('occasion_descriptions as od', 'od.occasion_id', 'occasions.id')
            ->where('od.language_id', currentLanguage()->id);

        if (is_array($occasionsId) && count($occasionsId)){
            $occasions->whereIn('occasions.id', $occasionsId);
        } elseif($occasionsId) {
            $occasions->where('occasions.id', $occasionsId);
        }

        if ($categoryId){
            $occasions->where('occasions.category_id', $categoryId);
        }

        $occasions->select([
            'occasions.*',
            'od.name',
        ]);

        return ($occasionsId && !is_array($occasionsId)) ? $occasions->first() : $occasions->get() ?? [];
    }

    /**
     * Get description of current language of The Category
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(OccasionDescription::class)->where('language_id', currentLanguage()->id);
    }

    /**
     * Get the description of the occasion.
     * @param int $language_id
     * @return HasMany
     */
    public function descriptions($language_id= 0) :HasMany
    {
        if ($language_id) {
            return $this->hasMany(OccasionDescription::class)->where('language_id', $language_id);
        }
        return $this->hasMany(OccasionDescription::class);
    }
}
