<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class NumberDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'title',
        'number_id',
        'language_id',
    ];

    /**
     * @return BelongsTo
     */
    public function state() :BelongsTo
    {
        return $this->belongsTo(Number::class);
    }
}
