<?php

namespace App;

use App\Helpers\ImageHelper;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class Number extends Model
{
    // Fields that mass assignment
    protected $fillable = ['number'];

    // Use soft delete
    use SoftDeletes;

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(NumberDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(NumberDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function withDescription($country_id = null, $number_id = null)
    {
        $numbers = self::join('number_descriptions as nd', 'nd.number_id', 'numbers.id')
            ->where('nd.language_id', currentLanguage()->id);

        if($country_id){
            $numbers->where('numbers.country_id', $country_id);
        }
        if ($number_id){
            $numbers->where('numbers.id', $number_id);
        }

        $numbers->select([
            'numbers.*',
            'nd.title',
        ]);
        return $number_id ? $numbers->first() : $numbers->get() ?? [];
    }

}
