<?php

namespace App\Http\Requests;

use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

/**
 * @property mixed password
 * @property mixed active_way
 */
class UserRegisterRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
//        $phonePattern = '/^(5){1}([0-9]{8})$/';
        $phonePattern = '/[0-9]{10,11}/';

        $rules=[
            'name'=> 'required|min:3',
            'email' => [
                'required',
                'email',
                'unique:users,email'
            ],
//            'code' => 'required|exists:countries,code',
//            'phone'=> [
//                "required",
//                "numeric",
////                "digits:10",
//                "regex:".$phonePattern,
//                'unique:users,phone'
//            ],
            'password'=> 'required|confirmed',
            'agreement'=> 'required|in:1,0',
            'email_receive'=> 'nullable|in:1,0',

        ];

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('members');
        $local = getCurrentLocale();
        $attributes= [
            'name'=> $field[$local]['name'] ?? __('members.name'),
            'email'=> $field[$local]['email'] ?? __('members.email'),
            'phone'=> $field[$local]['phone'] ?? __('members.phone'),
            'password'=> $field[$local]['password'] ?? __('members.password'),
            'code'=> $field[$local]['code'] ?? __('members.code'),
            'agreement'=> $field[$local]['agreement'] ?? __('members.agreement'),
            'email_receive'=> $field[$local]['email_receive'] ?? __('members.email_receive'),
            'password_confirmation'=> $field[$local]['password_confirmation'] ?? __('members.password_confirmation'),
        ];
        return $attributes;
    }

    public function messages()
    {
        return [
            'phone.digits' => __('members.phone_digits'),
//            'phone.regex' => __('members.phone_regex'),
        ];
    }

    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::ajax()){
            if ($validator->fails()){
                $errors = $validator->errors()->first();
                throw new HttpResponseException(response()->json(['errors' => $errors]));
            }

        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
