<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class SaveSelectedServicesRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules=[];

        $hallDates = $this->hall->available_dates['dates'];
        $rules['selected_day'] = 'required|in:'.implode(',', $hallDates);
        $rules['services'] = 'nullable|array|exists:services,id';
        $rules['added_services'] = 'nullable|array';

        if (request('services')){
            foreach (request('services') as $serKey => $services) {
                $serQuantity = request('services_quantity')[$serKey];
                if ($serQuantity == null || !is_numeric($serQuantity) || $serQuantity < 1){
                    $rules['all_services_quantity'] = 'required';
                }
            }
        }

        if (request('added_services')){
            foreach (request('added_services') as $addedSerKey => $addedService) {
                $addedSerQuantity = request('added_services_quantity')[$addedSerKey];
                if ($addedSerQuantity == null|| !is_numeric($addedSerQuantity) || $addedSerQuantity < 1){
                    $rules['all_added_services_quantity'] = 'required';
                }
            }
        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $attributes= [
            'selected_day'=>  __('reservations.selected_day'),
            'services'=>  __('reservations.services'),
            'added_services'=>  __('reservations.added_services'),
            'all_services_quantity'=>  __('reservations.services_quantity'),
            'all_added_services_quantity'=>  __('reservations.added_services_quantity'),
        ];
        return $attributes;
    }

    public function messages()
    {
        return [
            'selected_day.in' => __('reservations.selected_day_unavailable'),
        ];
    }

    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::ajax()){
            $errors = $validator->errors()->first();
            throw new HttpResponseException(response()->json(['errors' => $errors]));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
