<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\ValidationException;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Http\Exceptions\HttpResponseException;

class PartnerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        if (! Auth::check()) {
            return false;
        }
        if(in_array(Auth::user()->role, ['super_admin', 'admin', 'sub_admin']))
        {
            return true;
        }

        if(Auth::user()->hasModule( 'partners' ) )
        {
            return true;
        }
        return Auth::check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $rules=['image' => 'required'];

//        foreach (languages() as $lang) {
//            $lang_rules=[
//                'name_'.$lang->local=> 'required|min:3',
//                'slug_'.$lang->local=> [
//                    "required",
//                    Rule::unique('partner_descriptions', 'slug')->ignore($this->partner? $this->partner->id : 0, 'partner_id')
//                ],
//                'keywords_'.$lang->local=> 'required|min:3',
//                'meta_description_'.$lang->local=> 'required|min:3',
//                'description_'.$lang->local=> 'required|min:3',
//            ];
//            $rules= array_merge($rules, $lang_rules);
//        }

        return $rules;
    }

    /**
     * Get custom attributes for validator errors.
     *
     * @return array
     */
    public function attributes()
    {
        $field = metaFields('partners');
        $attributes=[];
        foreach (languages() as $lang) {
            $local = $lang->local == 'ar' ? '(عربي)' : '(English)';
            $lang_attributes=[
                'name_'.$lang->local=> ($field[$lang->local]['name'] ?? __('partners.name')) . $local,
                'slug_'.$lang->local=> ( $field[$lang->local]['slug'] ?? __('partners.slug')) . $local,
                'keywords_'.$lang->local=> ($field[$lang->local]['keywords'] ?? __('partners.keywords')) . $local,
                'meta_description_'.$lang->local=> ($field[$lang->local]['meta_description'] ?? __('partners.meta_description')) . $local,
                'description_'.$lang->local=> ($field[$lang->local]['description'] ?? __('partners.description')) . $local,
            ];
            $attributes= array_merge($attributes, $lang_attributes);
        }
        return $attributes;
    }
    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::wantsJson()){
            $errors = (new ValidationException($validator))->errors();
            throw new HttpResponseException(response()->json(['errors' => $errors], 422));
        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
