<?php

namespace App\Http\Requests;

use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Exceptions\HttpResponseException;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Validation\ValidationException;

class EvaluateRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'cleaning' => 'nullable|in:1,2,3,4,5',
            'services' => 'nullable|in:1,2,3,4,5',
            'staffs' => 'nullable|in:1,2,3,4,5',
            'comforts' => 'nullable|in:1,2,3,4,5',
            'financial_value' => 'nullable|in:1,2,3,4,5',
            'location' => 'nullable|in:1,2,3,4,5',
            'comment' => 'required|min:3|max:400',
        ];
    }

    public function attributes()
    {
        return [
            'cleaning' => __('halls.cleaning'),
            'services' =>  __('halls.services'),
            'staffs' =>  __('halls.staffs'),
            'comforts' =>  __('halls.comforts'),
            'financial_value' =>  __('halls.financial_value'),
            'location' =>  __('halls.location'),
            'comment' =>  __('halls.comment'),
        ];
    }
    /**
     * Handle a failed validation attempt.
     *
     * Override the parent method action if the request is for AJAX
     *
     * @param Validator $validator
     * @return void
     *
     * @throws ValidationException
     */
    protected function failedValidation(Validator $validator)
    {
        // Change response attitude if the request done via Ajax requests like API requests
        if(Request::ajax()){
            if ($validator->fails()){
                $errors = $validator->errors()->first();
                throw new HttpResponseException(response()->json(['errors' => $errors]));
            }

        } else {
            // Do the original action of the Form request class
            parent::failedValidation($validator);
        }
    }
}
