<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;

class UserAuth
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ( ! Auth::check() ) {
            return redirect()->route('userProvider.login');
        }

        if (Auth::check() && !in_array(Auth::user()->role, ['provider', 'user'])) {
            Auth::logout();
            return redirect()->route('userProvider.login');
        }

        return $next($request);
    }
}
