<?php

namespace App\Http\Controllers\Web;

use App\Http\Controllers\Controller;
use App\Http\Requests\VisitorMessageRequest;
use App\Page;
use App\VisitorMessage;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\View\View;

class VisitorMessageController extends Controller
{
    private $viewDirectory = 'web.contact_us.';

    /**
     * Show the Contact US details.
     * @param string|null $slug
     * @param Request $request
     * @return View
     */
    public function index(string $slug = null, Request $request) //:?View
    {
        $title = __('visitorMessages.head');
        return view( $this->viewDirectory.'index', get_defined_vars());
    }

    /**
     * Store a Message and send it to the admin in storage.
     *
     * @param VisitorMessageRequest $request
     * @return JsonResponse
     */
    public function store(VisitorMessageRequest $request) :JsonResponse
    {
        VisitorMessage::create($request->all());
        return response()->json(['message' => __('visitorMessages.message_success')]);
    }
}
