<?php


namespace App\Http\Controllers\Web;

use Illuminate\Http\Request;
use Illuminate\Notifications\Notification;
use NotificationChannels\Fcm\FcmChannel;
use NotificationChannels\Fcm\FcmMessage;
use NotificationChannels\Fcm\Resources\AndroidConfig;
use NotificationChannels\Fcm\Resources\AndroidFcmOptions;
use NotificationChannels\Fcm\Resources\AndroidNotification;
use NotificationChannels\Fcm\Resources\ApnsConfig;
use NotificationChannels\Fcm\Resources\ApnsFcmOptions;
use NotificationChannels\Fcm\Resources\FcmOptions;
use NotificationChannels\Fcm\Resources\WebpushConfig;
use NotificationChannels\Fcm\Resources\WebpushFcmOptions;
use Kreait\Firebase\Messaging\CloudMessage;
use Illuminate\Support\Facades\Auth;
use Firebase\Auth\Token\Exception\InvalidToken;
use Kreait\Firebase\JWT\CustomTokenGenerator;
use Kreait\Firebase\JWT\Error\IdTokenVerificationFailed;
use Kreait\Firebase\JWT\IdTokenVerifier;



class SendNotification extends Notification
{

    private $title;
    private $body;
    private $image;
    private $link;
    private $data;

    public function __construct($title = null, $body = null, $image = null, $data = [], $link = null)
    {
        $this->title = $title;
        $this->body = $body;
        $this->image = $image;
        $this->image = $image;
        $this->data = $data;
        $this->link = $link ?? request()->getHttpHost().request()->getBaseUrl().'/';
    }
    public function via($notifiable)
    {
        return [FcmChannel::class];
    }

    public function toFcm($notifiable)
    {
//        $user = Auth::user();
//        $clientEmail = 'firebase-adminsdk-vpd7z@spry-shade-331519.iam.gserviceaccount.com';
//        $privateKey = env('FIREBASE_PRIVATE_KEY');
//        $projectId = env('FIREBASE_PROJECT_ID');
//
//        $generator = CustomTokenGenerator::withClientEmailAndPrivateKey($clientEmail, $privateKey);
//        $token = $generator->createCustomToken('uid', ['first_claim' => 'first_value']);
//
//        $verifier = IdTokenVerifier::createWithProjectId($projectId);
//
//        $token = $verifier->verifyIdToken($token);
//
//        json_encode($token->headers(), JSON_PRETTY_PRINT);
//
//        json_encode($token->payload(), JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
//        $token->toString();
//        $tokenString = (string) $token;
//
//        dd($tokenString);

//        $user->update(['fcm_token' => $token]);

        return FcmMessage::create()
            ->setData($this->data)
            ->setNotification(\NotificationChannels\Fcm\Resources\Notification::create()
                ->setTitle($this->title)
                ->setBody($this->body)
                ->setImage($this->image)
            )
            ->setWebpush(
                WebpushConfig::create()->setFcmOptions(
                    WebpushFcmOptions::create()->setLink($this->link)
                )
            );
    }

    // optional method when using kreait/laravel-firebase:^3.0, this method can be omitted, defaults to the default project
    public function fcmProject($notifiable, $message)
    {
        // $message is what is returned by `toFcm`
        return 'MEETAT project'; // name of the firebase project to use
    }

}
