<?php

namespace App\Http\Controllers\Web;

use App\Http\Requests\NewsletterRequest;
use App\Newsletter;
use App\Http\Controllers\Controller;
use Illuminate\Http\JsonResponse;

class NewsletterController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @param NewsletterRequest $request
     * @return JsonResponse
     */
    public function store(NewsletterRequest $request) : JsonResponse
    {
        Newsletter::create($request->all());
        return response()->json(['message' => __('newsletters.newsletter_subscribe_success')]);
    }
}
