<?php


namespace App\Http\Controllers\Web;


use App\Http\Requests\LoginRequest;
use App\User;
use Illuminate\Contracts\View\Factory;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\View\View;

class LoginController
{
    protected $view = 'web.members.';


    /**
     * Show login form for all users type
     * @return Factory|RedirectResponse|View
     */
    public function login()
    {
        if (!Auth::check() || !in_array(Auth::user()->role, ['user', 'provider'])){
            Auth::logout();
        }
        $title = __('main.sign_in');
        return view($this->view.'login', compact('title'));
    }

    /**
     * Do login for all users
     * @param LoginRequest $loginRequest
     * @return RedirectResponse|Redirector
     */
    public function doLogin(LoginRequest $loginRequest)
    {
        $user = User::whereIn('role', ['user', 'provider'])
            ->where('email', $loginRequest->email)->first();

        if ($user && $user->role == 'user' && !$user->status){
            return response()->json(['errors' => __('members.account_disabled_by_admin')]);
        }
        if ($user && Hash::check($loginRequest->password, $user->password)) {
            $profile = $user->role == 'provider' ? session('http_referer') ?? route('provider.profile') : session('http_referer') ?? route('user.profile');
//            $url = session('http_referer') ? session('http_referer') : route('user.profile');
            Auth::login($user);
            session()->put(['store_device_token' => true]);
            return response()->json(['url' => $profile]);
        } else {
            return response()->json(['errors' => __('auth.failed')]);
        }
    }


    public function storeDeviceToken(Request $request)
    {
        if ($request->ajax() && !$request->isMethod('GET')){
            $token = $request->device_token;
            $data = [
                'token' => $token,
                'platform' => 'web'
            ];
            $user = Auth::user();
            $user->update([
                'device_token' => $data
            ]);

            return ['status' => true];
        }
    }

    public function test()
    {
//        $user = auth()->user();
//        $notification = $user->notify(new SendNotification('Hi', 'Hi Mohammed'));
//        dd($notification);

        return view('web.test_fcm');
    }

    /**
     * Logout for all users
     * @return RedirectResponse
     */
    public function logout()
    {
        $user = Auth::user();
        $user->update(['device_token' => ['token' => null, 'platform' => null]]);
        Auth::logout();
        session()->forget('http_referer');
        return redirect()->route('home');
    }

}
