<?php

namespace App\Http\Controllers\Web;

use App\About;
use App\Article;
use App\Category;
use App\City;
use App\Feature;
use App\Hall;
use App\Http\Controllers\Controller;
use App\Number;
use App\Occasion;
use App\Page;
use App\Partner;
use App\Photo;
use App\PhotoCategory;
use App\Policy;
use App\Product;
use App\Project;
use App\Room;
use App\Service;
use App\Slider;
use App\Staff;
use App\Video;
use App\WorkWay;
use Carbon\Carbon;
use Illuminate\Http\Request;

use App\User;
use Notification;
use App\Notifications\ArticlesNotification;
use App\WebsitePhoto;
use Config;
use Illuminate\View\View;

class HomeController extends Controller
{
    private $view = 'web.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {

        $title = __('main.home');
        $occasions = Occasion::withDescription();
        $categories = Category::withDescription();
        $cities = City::
//        whereHas('halls')
            join('city_descriptions as cd', 'cd.city_id', '=', 'cities.id')
            ->where('cd.language_id', '=', currentLanguage()->id)
            ->select([
                'cities.*',
                'cd.name',
            ])->cursor();

        $sliders = Slider::withDescription();
        $about = About::getAbout();

        // Get top halls rated
        $highHallsRates = $this->getHals('rate');

        // Get most popular halls
        $mostRequestHalls = $this->getHals('popular');

        $partners = Partner::cursor();

        $numbers = Number::withDescription();

        $pages = Page::withDescription([1]);

        return view($this->view.'home', get_defined_vars());
    }

    /**
     * Get halls
     * @param $type
     * @return array
     */
    private function getHals($type)
    {

        $languageId = currentLanguage()->id;
        $dateFrom = Carbon::now()->addMonths(-4)->format('Y-m-d');
        $dateTo = Carbon::now()->addMonths(-1)->format('Y-m-d');
        $halls = Hall::join('hall_descriptions as hd', 'hd.hall_id', 'halls.id')
            ->where('hd.language_id', $languageId)
            ->join('categories', 'categories.id', 'halls.category_id')
            ->join('category_descriptions as cat_desc', 'cat_desc.category_id', 'categories.id')
            ->where('cat_desc.language_id', $languageId)
            ->join('regions', 'regions.id', 'halls.region_id')
            ->where('regions.deleted_at', null)
            ->join('cities', 'cities.id', 'halls.city_id')
            ->where('cities.deleted_at', null)
            ->join('city_descriptions as city_desc', 'city_desc.city_id', 'cities.id')
            ->where('city_desc.language_id', $languageId)
            ->join('sectors', 'sectors.id', 'halls.sector_id')
            ->where('sectors.deleted_at', null)
            ->join('users', 'halls.user_id', 'users.id')
            ->select(
                [
                    'halls.*',
                    'hd.name as hall_name',
                    'cat_desc.name as category_name',
                    'users.name as provider_name',
                    'city_desc.name as city_name',
                ]
            )
            ->selectSub("SELECT ROUND(AVG(evaluate_average)) FROM evaluates WHERE hall_id = halls.id", 'rate');

        if ($type == 'rate'){
            $topRateHalls = $halls->get()->toArray();
            foreach ($topRateHalls as $key => $item) {
                if ($item['rate'] <= 3.5 ){
                    unset($topRateHalls[$key]);
                }
            }
            return  $topRateHalls ?? [];

        }

        if ($type == 'popular'){
            $halls->selectSub("SELECT COUNT(hall_id) FROM reservations WHERE hall_id = halls.id AND created_at BETWEEN CAST('$dateFrom' AS DATE) AND CAST('$dateTo' AS DATE)", 'reservation_count')->limit(10);
            $mostPopular = $halls->get()->toArray();
            foreach ($mostPopular as $key => $item) {
                if ($item['reservation_count'] <= 4 ){
                    unset($mostPopular[$key]);
                }
            }
            return  $mostPopular ?? [];
        }

    }

    public function privacyPolicy()
    {
        $title = __('policies.privacy_policy');
        $id = null;

        if (session('register_type') == 'provider'){
            $id = 1;
        }
        if (session('register_type') == 'user'){
            $id = 2;
        }

        $policy = Policy::withDescription($id);
        $lists = stripText($policy->privacy_policy_description_list);
        $lists = explode('@@', trim($lists));
//        session()->forget(['register_type']);

        return view($this->view.'privacy_policy', get_defined_vars());
    }

    public function termsConditions()
    {
        $title = __('policies.terms_conditions');
        $id = null;

        if (session('register_type') == 'provider'){
            $id = 1;
        }
        if (session('register_type') == 'user'){
            $id = 2;
        }

        $term = Policy::withDescription($id);
        $titleSplit = __('policies.terms_conditions');
        $titleSplit = explode(' ', $titleSplit, 2);
//        session()->forget(['register_type']);

        return view($this->view.'term_conditions', get_defined_vars());
    }


}
