<?php

namespace App\Http\Controllers\Web;

use App\About;
use App\Http\Controllers\Controller;
use App\Page;
use App\Photo;
use App\PhotoCategory;
use App\Product;
use App\Project;
use App\Room;
use App\Staff;
use Illuminate\Http\Request;

use App\User;
use Notification;
use App\Notifications\ArticlesNotification;
use App\WebsitePhoto;
use Config;
use Illuminate\View\View;

class AboutUsController extends Controller
{
    private $view = 'web.about_us.';

    /**
     * Show the application dashboard.
     * @return View
     */
    public function index(): View
    {
        $title = __('abouts.head');
        $about = About::getAbout();
        $lists = explode('@@', $about->about_us_list);
        return view($this->view.'index', get_defined_vars());
    }
}
