<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Reservation;
use Illuminate\Http\Request;
use Illuminate\View\View;

use App\User;

class WalletController extends Controller
{
    /** Redirect to this path after each operation success*/
    private $redirectSuccessPath = '/admin/wallets';
    /** View folder */
    private $viewDirectory = 'admin.wallets.';

    public function __construct()
    {
        $this->redirectSuccessPath = getCurrentLocale().$this->redirectSuccessPath;
    }

    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return View
     */
    public function index(Request $request) :View
    {
        $title= __('wallets.head');
        $request= $request->toArray();
        return view($this->viewDirectory.'index',get_defined_vars());
    }

    /**
     * return data of the wallets.
     *
     * @param Request $request
     * @return View
     */
    public function grid(Request $request) :View
    {
        $query = User::whereIn('role', ['provider'])->orderBy('created_at', 'DESC');

        if ($request->date_from) {
            $query->whereDate('created_at', '>=', $request->date_from);
        }

        if ($request->date_to) {
            $query->whereDate('created_at', '<=', $request->date_to);
        }

        if ($request->name) {
            $query->where('name', 'LIKE', '%'.$request->name.'%');
        }

        if ($request->phone) {
            $query->where('phone', 'LIKE', '%'.$request->phone.'%');
        }
        if ($request->email) {
            $query->where('email', 'LIKE', '%'.$request->email.'%');
        }

        if ( !is_null($request->status) && $request->status == 0) {
            $query->onlyTrashed();
        }

        $wallets= $query->paginate(1000);

        return view($this->viewDirectory.'grid',get_defined_vars());
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param User $wallet
     * @return View
     */
    public function reservationIndex(Request $request, User $wallet)
    {
        $title= __('wallets.edit');
        $request= $request->toArray();
        return view($this->viewDirectory.'reservations_index',get_defined_vars());
    }

    public function reservationGrid(User $wallet)
    {
        $languageId = currentLanguage()->id;
        $reservations = Reservation::where('reservations.provider_id', $wallet->id)
            ->join('halls', 'reservations.hall_id', 'halls.id')
            ->join('hall_descriptions as hall_desc', 'hall_desc.hall_id', 'halls.id')
            ->where('hall_desc.language_id', $languageId)
            ->join('users', 'users.id', 'reservations.user_id')
            ->select(
                [
                    'reservations.*',
                    'halls.images',
                    'hall_desc.name as hall_name',
                    'users.name as client_name',
                    'users.phone as client_phone',
                ]
            )->paginate(100);


//        $total = $wallets->sum('total');
//        $addedValueAmount = $wallets->sum('added_value_amount');
        $sitePercentage = $wallet->website_percentage ? $wallet->website_percentage : 15;
//        $totalSitePercentage = (($total-$addedValueAmount)*$sitePercentage)/100;
//
//        $netTotal = $total-$addedValueAmount-$totalSitePercentage;

        return view( $this->viewDirectory.'reservations_grid', get_defined_vars());
    }


    public function paidStatus(Request $request)
    {
        if ($request->ajax()){
            $reservation = Reservation::find($request->reservation_id);
            if (!$reservation){
                return ['errors' => __('reservations.not_found')];
            }
            $message = null;
            if ($request->is_paid == 'paid'){
                $reservation->update(['is_paid' => 1]);
                $message = __('reservations.paid_status_changed_successfully'). __('reservations.paid');
            }
            if ($request->is_paid == 'not_paid') {
                $reservation->update(['is_paid' => 0]);
                $message = __('reservations.paid_status_changed_successfully'). __('reservations.not_paid');
            }

            if (!in_array($request->is_paid, ['paid', 'not_paid'])){
                return ['errors' => __('reservations.unknown_paid_status')];
            }

            return ['message' => $message];

        }


    }

}
