<?php

namespace App\Http\Controllers\Admin;

use App\Hall;
use App\Http\Controllers\Controller;
use App\Reservation;
use App\User;
use Illuminate\Contracts\View\Factory;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\View\View;

/**
 * @property array weekDates
 */
class DashboardController extends Controller
{

    private $months = [];
    private $monthByNumbers = [];
    private $monthByNames = [];
    private $translatedMonths = [];

    public function __construct()
    {
        $date = Carbon::make(date('Y').'-12-1');
        $months = [];
        $monthByNumbers = [];
        $monthByNames = [];
        $translatedMonths = [];

        for ($i = 1; $i <= 12; $i++){
            $x = $date->addMonth();
            $month = $x->englishMonth;
            $months[] = $month;
            $monthByNumbers[] = $i;
            $monthByNames[$i] = $x->englishMonth;
            $translatedMonths[$i] = $x->getTranslatedMonthName();
        }

        $this->months = $months;
        $this->monthByNumbers = $monthByNumbers;
        $this->monthByNames = $monthByNames;
        $this->translatedMonths = $translatedMonths;

    }

    /**
     * Show the stats of the website.
     * @return Factory|View
     */

    public function index() :View
    {
        $title = __('dashboard.dashboard');

        $months = json_encode($this->months);

        $startYear = Carbon::now()->addYears(-7);
        $lastYear = Carbon::now();

        $startMonth = Carbon::now()->addMonths(-7);
        $lastMonth = Carbon::now();

        $startWeek = Carbon::now()->addWeeks(-7);
        $lastWeek = Carbon::now();

        $yesterday = Carbon::now()->addDays(-1);
        $today = Carbon::now();


        $yearVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startYear, $lastYear])
            ->selectSub("YEAR(created_at)", 'yearsCount')
            ->get()->groupBy('yearsCount')->toArray();

        $yearsData = [];
        $yearsAxis = [];
        $monthsData = [];
        $monthsAxis = [];
        $weeksData = [];
        $weeksAxis = [];

        foreach ($yearVisitors as $year => $yearVisitor) {
            $yearsData[] = count($yearVisitor);
            $yearsAxis[] = $year;
        }

        $yearsData = json_encode($yearsData);
        $yearsAxis = json_encode($yearsAxis);

        $monthVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startMonth, $lastMonth])
            ->selectSub("MONTH(created_at)", 'monthCount')
            ->get()->groupBy('monthCount')->toArray();

        foreach ($monthVisitors as $monthNumber => $monthVisitor) {
            $monthsData[] = count($monthVisitor);
            $monthsAxis[] = $this->translatedMonths[$monthNumber];
        }


        $monthsData = json_encode($monthsData);
        $monthsAxis = json_encode($monthsAxis);


        $weekVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$startWeek, $lastWeek])
            ->selectSub("WEEK(created_at)", 'weekCount')
            ->get()->groupBy('weekCount')->toArray();

        foreach ($weekVisitors as $weekNumber => $weekVisitor) {
            $weeksData[] = count($weekVisitor);
            $weeksAxis[] = $weekNumber;
        }

        $weeksData = json_encode($weeksData);
        $weeksAxis = json_encode($weeksAxis);

        $todayVisitors = DB::table('website_visitors')
            ->orderBy('created_at', 'asc')
            ->whereBetween('created_at', [$yesterday, $today])
            ->count();



        $reservations = DB::table('reservations')->whereNull('deleted_at')
            ->whereNotNull('re_status')
            ->get(['re_status', 'total'])
            ->groupBy('re_status')->toArray();

        $confirmedReservations = $reservations['confirmed'];
        $confirmedReSum = array_map(function ($value){
            return $value->total ;
        }, $confirmedReservations);

        $confirmedReSum = array_sum($confirmedReSum);

        $websitePercentage = settings('website_percentage');

        $platformPercentage = ($confirmedReSum*$websitePercentage)/100;

        $users = User::whereIn('role', ['user', 'provider'])->get(['role'])->groupBy('role');
        $hallsCounts = Hall::whereHallStatus(1)->count();

        $attendeesNumber = Reservation::whereNull('deleted_at')
            ->where('re_status', 'finished')->sum('person_count');

        return view('admin.index', get_defined_vars());
    }
}
