<?php

namespace App\Http\Controllers\Admin;

use App\User;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class CheckAccessController extends Controller
{
    /**
     * Static method to prevent Super admin added from the central from accessing other super-admins
     * Except the first super-admin as he is the owner and the super admin of the central CMS
     * 
     * @param int $id
     * @return bool
     */
    public static function preventSuperAdminToEditOtherSuperAdmin(int $id)
    {
        if (Auth::check()){
            $loggedInUser = Auth::user();
            $other = User::find($id);
            if ($loggedInUser->role == 'super_admin' && $other->role == 'super_admin' && 
             $loggedInUser->id != 1 && $other->id != $loggedInUser->id){
                return false;
            }
            return true;
        }

        return true;
    }

    /**
     * Static method to prevent Admin from accessing super-admins
     * 
     * @param int $id
     * @return bool
     */
    public static function preventAdminTOAccessSuperAdmin(int $id)
    {
        if (Auth::check()){
            $loggedInUser = Auth::user();
            $other = User::find($id);
            if ($loggedInUser->role == 'admin' && $other->role == 'super_admin'){
                return false;
            }
            return true;
        }

        return true;
    }

    /**
     * Static method to prevent moderators users from access Admins, or other sub-admins
     * 
     * @param int $id
     * @return bool
     */
    public static function preventSubAdminTOAccessOtherRoles(int $id)
    {
        if (Auth::check()){
            $loggedInUser = Auth::user();
            $other = User::find($id);
            if ($loggedInUser->role == 'sub_admin' && 
             (in_array($other->role, ['super_admin', 'admin']) || ('sub_admin' == $other->role && $loggedInUser->id != $other->id) )
            ){
                return false;
            }
            return true;
        }

        return true;
    }

}
