<?php
namespace App\Helpers;

/**
* Class based Helper to send Notifications
*/
class NotificationHelper
{

    /**
     * Helper to send Notifications
     * @param string $data
     * @param string $target
     * @return string
     */
    public static function sendNotification($data = '', $target = '') {
        //FCM API end-point
        $url = 'https://fcm.googleapis.com/fcm/send';
//        $url = 'https://www.googleapis.com/auth/firebase.messaging';
//        $url = 'https://iid.googleapis.com/iid/v1:batchImport';
//        $url = 'https://oauth2.googleapis.com/token';
//        $url = ' https://iid.googleapis.com/iid/info/IID_TOKEN';
        $server_key = config('app.firebase_server_key');
        $data['data'] = $data['notification'];
        $fields = array_merge($target, $data);
        $headers = array(
            'Content-Type:application/json',
            'Authorization:key=' . $server_key
        );
        //CURL request to route notification to FCM connection server (provided by Google)
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Oops! FCM Send Error: ' . curl_error($ch));
        }
        curl_close($ch);
        return $result;
    }
}


//$token= $currentUser->user->device_token['token'];
//$data['notification'] = array(
//    "title" => $shop->name.' - '.__('shops.current_user_notification', [], ($currentUser->user->lang ?? 'en')),
//    "message" => __('shops.current_user_notification', [], ($currentUser->user->lang ?? 'en')),
//    "shop_id" => $currentUser->shop_id,
//    "queue_id" => $currentUser->id,
//    "your_turn" => '1',
//    'customerTurn' => true,
//    "decrease" => '1',
//    "sound" => "default",
//    'type' => 1,
//);
//$target['to'] = $token;
//NotificationHelper::sendNotification($data, $target);


