<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Carbon;

/**
 * @property mixed reservation_type
 * @property mixed booking_amount_per_day
 * @property mixed total_capacity
 * @property mixed booking_amount_per_person
 * @property mixed|string available_dates
 * @property mixed hall_status
 * @property mixed allow_requests
 * @property mixed allow_services
 * @property mixed discount_dates
 * @property mixed added_services
 */
class Hall extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'rate',
        'views_counts',
        'is_offer',
        'allow_services',
        'user_id',
        'category_id',
        'table_ids',
        'occasions',
        'reservation_way',
        'reservation_type',
        'capacity',
        'total_capacity',
        'min_capacity',
        'booking_amount_per_person',
        'booking_amount_per_day',
        'lat',
        'lng',
        'city_id',
        'region_id',
        'sector_id',
        'street',
        'added_services',
        'images',
        'available_dates',
        'unavailable_dates',
        'discount_dates',
        'hall_status',
        'allow_requests',
//        'all_dates',
//        'reserved_date',
//        'discount_date',
//        'booking_from',
//        'booking_to',
//        'discount_booking_from',
//        'discount_booking_to',
    ];

    protected $casts = [
        'images' => 'array',
        'added_Services' => 'array',
        'occasions' => 'array',
        'available_dates' => 'array',
        'unavailable_dates' => 'array',
        'discount_dates' => 'array',
        'all_dates' => 'array',
        'table_ids' => 'array',
//        'reserved_date' => 'array',
//        'discount_date' => 'array',
    ];

    public function descriptions()
    {
        return $this->hasMany(HallDescription::class);
    }


    public function provider()
    {
        return $this->belongsTo(User::class, 'user_id', 'id')->where('users.role', '=', 'provider');
    }

    public static function withDescription($providerId = null, $hallId = null, $cityId = null, $status = null)
    {
        $languageId = currentLanguage()->id;
        $halls = self::orderBy('halls.id', 'desc')->join('hall_descriptions as hd', 'hd.hall_id', 'halls.id')
            ->where('hd.language_id', $languageId);

        if ($status){
            $halls->where('halls.hall_status', $status);
        }

        if ($hallId){
            $halls->where('halls.id', $hallId);
        }
        if ($providerId){
            $halls->where('halls.user_id', $providerId);
        }
        if ($cityId){
            $halls->where('halls.city_id', $cityId);
        }

        $halls->select(
            [
                'halls.*',
                'hd.name as hall_name',
                'hd.description as hall_description',
                'hd.reservation_condition',
                'hd.features',
            ]
        );

        return $hallId ? $halls->first() : $halls->get();

    }

    public function evaluates()
    {
        return $this->hasMany(Evaluate::class);
    }


    /**
     * To generate dates from => to in hall available dates
     * @return array
     */
    public function getAvailableDateAttribute()
    {
        $availableDates = is_string($this->available_dates)? json_decode($this->available_dates, true) : $this->available_dates;
        return  $availableDates;
    }

    /**
     * To generate dates from => to in hall available dates
     * @return array
     */
    public function getAddedServiceAteAttribute()
    {
        $addedServices = is_string($this->added_services)? json_decode($this->added_services, true) : $this->added_services;
        dd($addedServices);
        return  $addedServices;
    }


}
