<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CountryDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'name',
        'country_id',
        'language_id',
    ];

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(CountryDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(CountryDescription::class)->where('language_id', currentLanguage()->id);
    }
}
