<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Contract extends Model
{
    use SoftDeletes;

    public static function withDescription($id = null)
    {
        $language_id = currentLanguage()->id;
        $contracts = self::join('contract_descriptions as pd', 'pd.contract_id', 'contracts.id')
            ->where('pd.language_id', $language_id);
        if ($id){
            $contracts->where('contracts.id', $id);
        }
        $contracts->select([
            'contracts.*',
            'pd.text',
        ]);

        return $contracts->first();
    }
}
