<?php

namespace App\Console\Commands;

use App\Helpers\Sms;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class SmsReservation extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reservation:sms';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        Log::info('Task schedule run successfully from reservations reminder sms');

//        date_default_timezone_set('Asia/Riyadh');
        date_default_timezone_set('Africa/Cairo');
        $date = Carbon::now()->addDays(1)->format('Y-m-d');
        $reservations = DB::table('reservations')
            ->where('reservations.re_status', '=', 'confirmed')
            ->where('reservations.canceled_from', '=', null)
            ->where('reservations.deleted_at', '=', null)
            ->where('reservations.re_date_from', '=', $date)
            ->join('users', 'users.id', '=', 'reservations.user_id')
            ->join('halls', 'halls.id', '=', 'reservations.hall_id')
            ->where('halls.deleted_at', '=', null)
            ->join('hall_descriptions as hall_desc', 'halls.id', '=', 'hall_desc.hall_id')
            ->where('hall_desc.language_id', currentLanguage()->id)
            ->select(['reservations.re_date_from','users.name as user_name','users.code', 'users.phone', 'hall_desc.name as hall_name'])
            ->cursor();

        foreach ($reservations as $reservation) {
            $phone = str_replace('+', '', $reservation->code).$reservation->phone;
            $message = __('reservations.reservation_remember_message_1').
                $reservation->user_name.
                __('reservations.reservation_remember_message_2').
                $reservation->hall_name.
                __('reservations.reservation_remember_message_3').
                $reservation->re_date_from;

            try{ Sms::send($phone, $message); } catch (\Exception $exception){}
        }

    }
}
