<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CityDescription extends Model
{
    // Disable timestamp
    public $timestamps = false;


    protected $fillable = [
        'name',
        'city_id',
        'language_id',
    ];

    /**
     * @return BelongsTo
     */
    public function state() :BelongsTo
    {
        return $this->belongsTo(City::class);
    }
}
