<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;
class City extends Model
{
    // Fields that mass assignment
    protected $fillable = ['photo', 'region_id'];

    // Use soft delete
    use SoftDeletes;

    /**
     * Get description for pages
     * @return HasMany
     */
    public function descriptions() :HasMany
    {
        return $this->hasMany(CityDescription::class);
    }

    /**
     * Get description of current language for pages
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(CityDescription::class)->where('language_id', currentLanguage()->id);
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function halls()
    {
        return $this->hasMany(Hall::class);
    }

    public static function withDescription($region_id = null, $city_id = null)
    {
        $cities = self::join('city_descriptions as cd', 'cd.city_id', 'cities.id')
            ->where('cd.language_id', currentLanguage()->id);

        if($region_id){
            $cities->where('cities.region_id', $region_id);
        }

        if ($city_id){
            $cities->where('cities.id', $city_id);
        }

        $cities->select([
            'cities.*',
            'cd.name',
        ]);
        return $city_id ? $cities->first() : $cities->cursor() ?? [];
    }

}
