<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class CategoryDescription extends Model
{
    // No Timestamp
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'category_id', 'language_id'
    ];

    /**
     * Get the url
     */
    public function getUrlAttribute(): string
	{
		return action('Admin\CategoryController@details', [$this->id, $this->name]);
	}
}
