<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class Category extends Model
{
    // For soft delete
    use SoftDeletes;


    public static function withDescription($categoriesId = null)
    {
        $categories = self::join('category_descriptions as cd', 'cd.category_id', 'categories.id')
            ->where('cd.language_id', currentLanguage()->id);

        if (is_array($categoriesId) && count($categoriesId)){
            $categories->whereIn('categories.id', $categoriesId);
        } elseif($categoriesId) {
            $categories->where('categories.id', $categoriesId);
        }

        $categories->select([
            'categories.*',
            'cd.name',
        ]);

        return $categoriesId ? $categories->first() : $categories->get() ?? [];
    }

    /**
     * Get description of current language of The Category
     * @return HasOne
     */
    public function currentDescription() :HasOne
    {
        return $this->hasOne(CategoryDescription::class)->where('language_id', currentLanguage()->id);
    }

    /**
     * Get the description of the category.
     * @param int $language_id
     * @return HasMany
     */
    public function descriptions($language_id= 0) :HasMany
    {
        if ($language_id) {
            return $this->hasMany(CategoryDescription::class)->where('language_id', $language_id);
        }
        return $this->hasMany(CategoryDescription::class);
    }
}
