<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class About extends Model
{
    use SoftDeletes;

    protected $fillable = [
        'image',
        'video',
        ];


    public function descriptions()
    {
        return $this->hasMany(AboutDescription::class)->where('language_id', currentLanguage()->id);
    }

    public static function getAbout()
    {
        $language_id = currentLanguage()->id;
        return self::first()->join('about_descriptions as ad', 'ad.about_id', 'abouts.id')
            ->where('ad.language_id', $language_id)
            ->select(['abouts.*', 'ad.*'])->first();
    }
}
