@extends('web.layouts.container')
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{__('reservations.edit')}} </li>
                </ol>
                <h3> {{__('reservations.edit')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <!--Start reservation_det -->
    <section class="reservation_det">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="swiper-container single-hall-swiper">
                        <div class="swiper-wrapper">
                            @if(count(json_decode($userReservation['images'])))
                                @foreach(json_decode($userReservation['images']) as $image)
                                    <div class="swiper-slide">
                                        <img src="{{asset($image)}}" alt="" class="hall-img">
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    <div class="reservation_item">
                        <div class="row">
                            <!-- Resevation details -->
                            <div class="col-md-6">
                                <div class="content">
                                    <h5 class="name mb-3"><b>{{$userReservation->hall_name}}</b></h5>
                                    <span class="data d-block"><b>{{$userReservation->category_name}}</b> <small class="num mr-1 ml-1">#{{$userReservation->re_no}}</small></span>
                                    <p class="data mt-2 "><i class="far fa-calendar-alt"></i> {{date('d-m-Y', strtotime($userReservation->re_date_from))}}</p>
                                    <p class="data"><i class="far fa-user"></i>{{__('halls.capacity')}} <b class="mr-1 ml-1">{{$userReservation->capacity}} {{__('members.persons')}}</b></p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="left-data">
                                    @if($userReservation->re_status == 'confirmed') <span class="badge  badge_completed">{{__('reservations.confirmed')}}</span> @endif
                                    @if($userReservation->re_status == 'unconfirmed') <span class="badge  badge_uncertain">{{__('reservations.unconfirmed')}}</span> @endif
                                    @if($userReservation->re_status == 'waiting_for_pay') <span class="badge badge_pinding">{{__('reservations.waiting_for_pay')}}</span> @endif
                                    @if($userReservation->re_status == 'canceled') <span class="badge badge_canceled">{{__('reservations.canceled')}}</span> @endif
                                    @if($userReservation->re_status == 'finished') <span class="badge badge_expired">{{__('reservations.finished')}}</span> @endif
                                    @if($userReservation->re_status == 'reject') <span class="badge badge_canceled">{{__('reservations.reject')}}</span> @endif
                                    <h3 class="price mt-4 dir-l"><b>{{$userReservation->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="prof-info">
                                    <img src="{{asset('assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                    <div class="text">
                                        <span class="title">{{__('reservations.provider_name')}}</span>
                                        <h6 class="name mb-0">{{$userReservation->provider_name}}</h6>
                                    </div>
                                </div>
                            </div>
                            @if($userReservation->person_count)
                                <div class="col-md-3">
                                    <div class="prof-info">
                                        <img src="{{asset('assets/web/images/icons/team.svg')}}" alt="" class="prof_img user_icon">
                                        <div class="text">
                                            <span class="title">  {{__('reservations.person_count')}} </span>
                                            <h6 class="name mb-0"> {{$userReservation->person_count}} {{__('members.persons')}}  </h6>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            @if($userReservation->re_status == 'confirmed')
                                <div class="col-md-3">
                                    <button class="prof-info" data-toggle="modal" data-target="#modal_bill">
                                        <img src="{{asset('assets/web/images/icons/bill.png')}}" alt="" class="prof_img user_icon">
                                        <div class="text">
                                            {{--                                            <span class="title"> {{__('reservations.bill_file')}} </span>--}}
                                            <h6 class="name mb-0"> {{__('reservations.bill_file')}}  </h6>
                                        </div>
                                    </button>
                                </div>
                            @endif



                        <!-- Modal -->
                            <div class="modal fade modal_bill modal_new_bill cont_print" id="modal_bill" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            {{--                                            <h5 class="modal-title" id="exampleModalLongTitle">{{__('reservations.bill_details')}}</h5>--}}
                                            {{--                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">--}}
                                            {{--                                                <span aria-hidden="true">&times;</span>--}}
                                            {{--                                            </button>--}}
                                        </div>
                                        <div class="modal-body">

                                            <section class="mail_meet">
                                                {{--Meet services details--}}

                                                <div class="cont">
                                                    <div class="content">
                                                        <div class="logo">
                                                            <img src="{{asset('assets/web/images/logo-footer.svg')}}" alt="">
                                                        </div>
                                                        <div class="top_inf">
                                                            <div class="r_side">
                                                                <h6>{{$userReservation->hall_name}}</h6>
                                                                <p>#{{$userReservation->re_no}}</p>
                                                                <div class="date">
                                                                    <img src="{{asset('assets/web/images/icons/Icon material-date-range.png')}}" alt="">
                                                                    <span>{{date('d M, Y', strtotime($userReservation->re_date_from))}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="l_side">
                                                                <span class="butn">{{__('reservations.'.$userReservation->re_status)}}</span>
                                                                {{--                                                                <div class="price">--}}
                                                                {{--                                                                    <strong>{{$userReservation->total}} </strong> <small>{{__('reservations.sar')}}</small>--}}
                                                                {{--                                                                </div>--}}
                                                            </div>
                                                        </div>
                                                        <div class="user_detials">
                                                            <ul>
                                                                <li>
                                                                    <div class="img">
                                                                        <img src="{{asset('assets/web/images/avatar.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.provider_name')}}</p>
                                                                        <h6>{{$userReservation->provider_name}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/team.svg')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.person_count')}}</p>
                                                                        <h6> {{$userReservation->person_count}} <small>{{__('reservations.person')}}</small></h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.address')}}</p>
                                                                        <h6>{{$userReservation->street}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/phone.svg')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.phone')}}</p>
                                                                        <h6>{{$userReservation->provider_phone}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.person_name_charge')}}</p>
                                                                        <h6>{{$userReservation->provider_name}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.user_name')}}</p>
                                                                        <h6>{{$userReservation->client_name}}</h6>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="mt-5 col-md-12">
                                                    <h3 class="bill_title">{{__('reservations.bill_summary')}}</h3>
                                                    <div class="table-responsive">
                                                        <table class="table bill_table">
                                                            <thead>
                                                            <tr>
                                                                <th scope="col" class="day_back_dark">{!! __('reservations.bill_description') !!}</th>
                                                                <th scope="col" class="day_back_dark">{!! __('reservations.bill_quantity') !!}</th>
                                                                <th scope="col" class="day_back_dark">{!! __('reservations.bill_unit_price') !!}</th>
                                                                <th scope="col" class="day_back_dark"> {!! __('reservations.bill_total') !!} </th>
                                                                <th scope="col" class="day_back_dark"> {!! __('reservations.bill_discount') !!} </th>
                                                                <th scope="col" class="day_back_dark"> {!! __('reservations.bill_net_amount') !!} </th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                            <!-- -------- day 1 -------- -->
                                                            @if(count($servicesAndAddedServices))
                                                                @foreach($servicesAndAddedServices as $day => $servicesAndAddedService)
                                                                    <?php
                                                                    /** @var TYPE_NAME $reservation */
                                                                    /** @var TYPE_NAME $servicesAndAddedService */
                                                                    /** @var TYPE_NAME $day */
                                                                    /** @var TYPE_NAME $hall */

                                                                    $reservationPrice = $reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person;
                                                                    $discountPercentage = ($servicesAndAddedService['services'][0] ?? $servicesAndAddedService['added_services'][0])['discount_percentage'];
                                                                    $count = $hall->reservation_type == 'person_count' ? $reservation->person_count : 1;
                                                                    $total = $reservationPrice*$count;
                                                                    $discount = ($total*$discountPercentage)/100;
                                                                    $remaining = $total-$discount;
                                                                    $sar = __('reservations.sar');
                                                                    ?>
                                                                    <tr class="day_back">
                                                                        <th scope="row" class="day_back">
                                                                            <span class=""> {{__('reservations.day')}} {{dateInfo($day, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($day, ['format' => 'Y / m / d'])}}) </span>
                                                                        </th>
                                                                        <td>
                                                                            {{$count}}
                                                                        </td>
                                                                        <td>{{$reservationPrice . ' ' . $sar}} </td>
                                                                        <td>{{$total . ' ' . $sar}} </td>
                                                                        <td>{{$discount . ' ' . $sar}} </td>
                                                                        <td>{{$remaining . ' ' . $sar}} </td>

                                                                    </tr>
                                                                    @if(($servicesAndAddedService['services'] ?? null))
                                                                        <tr class="day_color1">
                                                                            <th scope="row">
                                                                                <span class=""> {!! __('reservations.bill_approved_services') !!} </span>
                                                                            </th>
                                                                            <td></td><td></td><td></td><td></td><td></td>
                                                                        </tr>
                                                                        @foreach($servicesAndAddedService['services'] as $oneSer)
                                                                            <?php
                                                                            /** @var TYPE_NAME $oneSer */
                                                                            $servicePrice = $oneSer['price']*$oneSer['quantity'];
                                                                            $serviceDiscount = ($servicePrice*$oneSer['discount_percentage'])/100;
                                                                            $serviceRemaining = $servicePrice-$serviceDiscount;

                                                                            ?>
                                                                            <tr class="day_color1">
                                                                                <th scope="row">
                                                                                    <span> {{$oneSer['name']}} </span>
                                                                                </th>
                                                                                <td>{{$oneSer['quantity']}}</td>
                                                                                <td>{{$oneSer['price'] . ' ' . $sar}} </td>
                                                                                <td>{{$servicePrice . ' ' . $sar}}</td>
                                                                                <td>{{$serviceDiscount . ' ' . $sar}}</td>
                                                                                <td>{{$serviceRemaining . ' ' . $sar}} </td>
                                                                            </tr>
                                                                        @endforeach

                                                                    @endif
                                                                    @if(($servicesAndAddedService['added_services'] ?? null))
                                                                        <tr class="day_color1">
                                                                            <th scope="row">
                                                                                <span class=""> {!! __('reservations.bill_added_services') !!} </span>
                                                                            </th>
                                                                            <td></td><td></td><td></td><td></td><td></td>
                                                                        </tr>
                                                                        @foreach($servicesAndAddedService['added_services'] as $oneAddedSer)
                                                                            <?php
                                                                            /** @var TYPE_NAME $oneAddedSer */
                                                                            $addedServicePrice = $oneAddedSer['price']*$oneAddedSer['quantity'];
                                                                            $addedServiceDiscount = ($addedServicePrice*$oneAddedSer['discount_percentage'])/100;
                                                                            $addedServiceRemaining = $addedServicePrice-$addedServiceDiscount;

                                                                            ?>
                                                                            <tr class="day_color1">
                                                                                <th scope="row">
                                                                                    <span> {{$oneAddedSer['name']}} </span>
                                                                                </th>
                                                                                <td>{{$oneAddedSer['quantity']}}</td>
                                                                                <td>{{$oneAddedSer['price'] . ' ' . $sar}} </td>
                                                                                <td>{{$addedServicePrice . ' ' . $sar}}</td>
                                                                                <td>{{$addedServiceDiscount . ' ' . $sar}}</td>
                                                                                <td>{{$addedServiceRemaining . ' ' . $sar}} </td>
                                                                            </tr>
                                                                        @endforeach
                                                                    @endif
                                                                @endforeach
                                                            @else
                                                                @foreach($reservationDays['days'] as $key => $reservationDay)
                                                                    <?php
                                                                    /** @var TYPE_NAME $reservation */
                                                                    /** @var TYPE_NAME $reservationDays */
                                                                    /** @var TYPE_NAME $day */
                                                                    /** @var TYPE_NAME $key */

                                                                    $reservationPrice = ($reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person);
                                                                    $discountPercentage = $reservationDays['percentage'][$key];
                                                                    $count = $hall->reservation_type == 'person_count' ? $reservation->person_count : 1;
                                                                    $total = ($reservationPrice*$count);
                                                                    $discount = ($total*$discountPercentage)/100;
                                                                    $remaining = $total-$discount;
                                                                    $sar = __('reservations.sar');
                                                                    ?>
                                                                    <tr class="day_back">
                                                                        <th scope="row" class="day_back">
                                                                            <span class=""> {{__('reservations.day')}} {{dateInfo($reservationDay, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($reservationDay, ['format' => 'Y / m / d'])}}) </span>
                                                                        </th>
                                                                        <td>
                                                                            {{$count}}
                                                                        </td>
                                                                        <td>{{$reservationPrice . ' ' . $sar}} </td>
                                                                        <td>{{$total . ' ' . $sar}} </td>
                                                                        <td>{{$discount . ' ' . $sar}} </td>
                                                                        <td>{{$remaining . ' ' . $sar}} </td>

                                                                    </tr>
                                                                @endforeach

                                                            @endif


                                                            {{-- Start Bill footer--}}
                                                            <tr>
                                                                <th scope="row" class="day_back_dark">
                                                                    <span>{!! __('reservations.bill_total_before_tax') !!}</span>
                                                                </th>
                                                                <td colspan="4">
                                                                </td>
                                                                <td>{{$totalBeforeAddedValue . ' ' . __('reservations.sar')}}</td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row" class="day_back_dark">
                                                                    <span>{!! __('reservations.bill_added_value') !!}</span>
                                                                </th>
                                                                <td colspan="4">
                                                                </td>
                                                                <td>
                                                                    {{($settings['added_value'] ?? 0)}}%
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <th scope="row" class="day_back_dark">
                                                                    <span>{!! __('reservations.bill_total_after_tax') !!}</span>
                                                                </th>
                                                                <td colspan="4">
                                                                </td>
                                                                <td>{{$totalAfterAddedValue . ' ' . __('reservations.sar')}}</td>
                                                            </tr>
                                                            {{--                                        <tr>--}}
                                                            {{--                                            <th scope="row" class="day_back_dark">--}}
                                                            {{--                                                <span>{{__('reservations.site_percentage')}}</span>--}}
                                                            {{--                                            </th>--}}
                                                            {{--                                            <td colspan="4">--}}
                                                            {{--                                            </td>--}}
                                                            {{--                                            <td>--}}
                                                            {{--                                                {{$sitePercentageValue}} {{'(' . ($settings['website_percentage'] ?? 0) . ')' . '%'}}--}}
                                                            {{--                                            </td>--}}
                                                            {{--                                        </tr>--}}
                                                            {{-- End Bill footer--}}
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>

                                            </section>
                                        </div>
                                        <div class="modal-footer">
                                            <button id="print_btn" href="#0" type="button" class="btn btn-secondary bg-success">{{__('reservations.print')}}</button>
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('reservations.close')}}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <!-- Location details -->
                            <div class="col-lg-12">
                                <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon">{{__('halls.hall_location')}}</h5>
                            </div>
                            <div class="col-md-12">
                                <div class="map-box">
                                    <div style="border:0; height: 400px; width: 100%" class="map" id="map"></div>
                                    {{--                                    <iframe width="100%" height="250" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=1%20Grafton%20Street,%20Dublin,%20Ireland+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>--}}
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="hall_contacts center-vr">
                                    <div class="row">
                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('reservations.address')}}</p>
                                            <h6 class="data mb-4"><b>{{$userReservation->street}}</b></h6>
                                        </div>

                                        <div class="col-lg-3 col-6">
                                            <p class="labeled"><img src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="" class="icon"> {{__('members.provider_name')}}</p>
                                            <h6 class="data"><b>{{$userReservation->provider_name}}</b></h6>
                                        </div>

                                        <div class="col-lg-3 col-6">
                                            <p class="labeled mt-4"><img src="{{asset('assets/web/images/icons/phone.svg')}}" alt="" class="icon"> {{__('members.phone')}}</p>
                                            <h6 class="data"><b>{{$userReservation->provider_phone}}</b></h6>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-md-12">
                                <h5 class="mt-4 mb-4"> {{__('reservations.other_details')}}</h5>
                                <textarea name="" class="form-control" cols="30" rows="10">{{$userReservation->other_details}}</textarea>
                            </div>

                            <!-- Invetations -->
                            @if($userReservation->re_status == 'confirmed')
                                <div class="col-lg-12">
                                    <h5 class="headline mt-5 mb-4">  {{__('reservations.invite_people_to_book')}}</h5>
                                    <nav class="inviting-nav mb-5">
                                        <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                            <a class="nav-link active" id="nav-mail-tab" data-toggle="tab" href="#nav-mail" role="tab" aria-controls="nav-mail" aria-selected="true"> {{__('reservations.invite_by_email')}} </a>
                                            <a class="nav-link" id="nav-phone-tab" data-toggle="tab" href="#nav-phone" role="tab" aria-controls="nav-phone" aria-selected="false">{{__('reservations.invite_by_phone')}}</a>
                                        </div>
                                    </nav>
                                    @if($userReservation->person_count)
                                        <p class="remaining_invitations"> {{__('reservations.unused_invite_count')}} <b class="person_count">{{$userReservation->invitation_count ? ($userReservation->person_count-$userReservation->invitation_count) : $userReservation->person_count}}</b></p>
                                    @endif
                                    <div class="tab-content" id="nav-tabContent">
                                        <div class="tab-pane fade show active" id="nav-mail" role="tabpanel" aria-labelledby="nav-mail-tab">
                                            <form action="{{route('reservation.invitation', $userReservation->id)}}" method="post" class="invitation_from">
                                                {{-- Invitation cards--}}
                                                <div class="invit-radios invitations_radios mb-5">
                                                    <p class="remaining_invitations">{{__('reservations.select_invitation_format')}}</p>
                                                    <div class="inFlex">
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" id="template_1" name="invitation_template" value="template_1" class="custom-control-input">
                                                            <label class="custom-control-label" for="template_1">
                                                                <img src="{{asset('assets/web/images/invitation_1.png')}}" alt="" class="invit-img"/>
                                                            </label>
                                                        </div>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" id="template_2" name="invitation_template" value="template_2" class="custom-control-input">
                                                            <label class="custom-control-label" for="template_2">
                                                                <img src="{{asset('assets/web/images/invitation_2.png')}}" alt="" class="invit-img"/>
                                                            </label>
                                                        </div>
                                                        <div class="custom-control custom-radio">
                                                            <input type="radio" id="template_3" name="invitation_template" value="template_3" class="custom-control-input">
                                                            <label class="custom-control-label" for="template_3">
                                                                <img src="{{asset('assets/web/images/invitation_3.png')}}" alt="" class="invit-img"/>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-7">
                                                    <div class="form-group">
                                                        <input name="email" class="form-control" placeholder="{{__('members.email')}} ...">
                                                        <button class="submit-btn invitation_button">{{__('reservations.send')}}</button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                        <div class="tab-pane fade" id="nav-phone" role="tabpanel" aria-labelledby="nav-phone-tab">
                                            <div class="col-lg-7">
                                                <form action="{{route('reservation.invitation', $userReservation->id)}}" method="post" class="invitation_from">
                                                    <div class="form-group">
                                                        <input name="phone" class="form-control" placeholder=" {{__('members.phone')}} ...">
                                                        <span class="text-danger">(Example: 5300000000)</span>
                                                        <button class="submit-btn invitation_button">{{__('reservations.send')}}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-7">
                                        <div class="mails-box">
                                            <p class="title_t"> {{__('reservations.sent_email_list')}} </p>
                                            <div class="content invitation_container">
                                                @if(is_array($userReservation->invitations) && count($userReservation->invitations))
                                                    @foreach($userReservation->invitations as $invitation)
                                                        <div class="item">
                                                            <p class="data mb-0">{{$invitation}}</p>
                                                        </div>
                                                    @endforeach
                                                @else
                                                    <div class="item no_invitation">
                                                        <p class="data mb-0">{{__('reservations.no_invitation')}}</p>
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    </div>

                                </div>
                        @endif

                        <!-- Note -->
                            <div class="col-lg-12">
                                <div class="note mt-5">
                                    <img src="{{asset('assets/web/images/saudi_exhibition_logo.png')}}" alt="" class="saudi_logo">
                                    <span class="text"> <b>{!! __('reservations.enterprise_note') !!}</b></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/reservations.user_reservation_details.js') }}"></script>

    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <script defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDpVcBEVHKN5-iO0-z5MoEeLLpfV18JZjg&callback=initMap"></script>
    <script>
        let lat = "{{$hall->lat}}",
            lng = "{{$hall->lng}}";
        function initMap() {
            /** Map one block */
            let map = new google.maps.Map(document.querySelector(".map"), {
                zoom: 7,
                center: { lat: parseFloat(lat) , lng: parseFloat(lng) }
            });

            new google.maps.Marker({
                map: map,
                animation: google.maps.Animation.DROP,
                position: { lat: parseFloat(lat) , lng: parseFloat(lng) }
            });


        }
    </script>
@endsection

