@extends('web.layouts.container')
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">  {{__('reservations.bill_summary')}} </li>
                </ol>
                <h3> {{__('reservations.bill_summary')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="reservation_det bill-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 m-auto">
                    <div class="reservation_item">
                        <h3 class="bill_title">{{__('reservations.bill_summary')}}</h3>
                        <div class="table-responsive">
                            <table class="table bill_table">
                                <thead>
                                <tr>
                                    <th scope="col" class="day_back_dark">{!! __('reservations.bill_description') !!}</th>
                                    <th scope="col" class="day_back_dark">{!! __('reservations.bill_quantity') !!}</th>
                                    <th scope="col" class="day_back_dark">{!! __('reservations.bill_unit_price') !!}</th>
                                    <th scope="col" class="day_back_dark"> {!! __('reservations.bill_total') !!} </th>
                                    <th scope="col" class="day_back_dark"> {!! __('reservations.bill_discount') !!} </th>
                                    <th scope="col" class="day_back_dark"> {!! __('reservations.bill_net_amount') !!} </th>
                                </tr>
                                </thead>
                                <tbody>
                                <!-- -------- day 1 -------- -->
                                @if(count($servicesAndAddedServices))
                                    @foreach($servicesAndAddedServices as $day => $servicesAndAddedService)
                                        <?php
                                        /** @var TYPE_NAME $reservation */
                                        /** @var TYPE_NAME $servicesAndAddedService */
                                        /** @var TYPE_NAME $day */
                                        /** @var TYPE_NAME $hall */

                                        $reservationPrice = $reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person;
                                        $discountPercentage = ($servicesAndAddedService['services'][0] ?? $servicesAndAddedService['added_services'][0])['discount_percentage'];
                                        $count = $hall->reservation_type == 'person_count' ? $reservation->person_count : 1;
                                        $total = $reservationPrice*$count;
                                        $discount = ($total*$discountPercentage)/100;
                                        $remaining = $total-$discount;
                                        $sar = __('reservations.sar');
                                        ?>
                                        <tr class="day_back">
                                            <th scope="row" class="day_back">
                                                <span class=""> {{__('reservations.day')}} {{dateInfo($day, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($day, ['format' => 'Y / m / d'])}}) </span>
                                            </th>
                                            <td>
                                                {{$count}}
                                            </td>
                                            <td>{{$reservationPrice . ' ' . $sar}} </td>
                                            <td>{{$total . ' ' . $sar}} </td>
                                            <td>{{$discount . ' ' . $sar}} </td>
                                            <td>{{$remaining . ' ' . $sar}} </td>

                                        </tr>
                                        @if(($servicesAndAddedService['services'] ?? null))
                                            <tr class="day_color1">
                                                <th scope="row">
                                                    <span class=""> {!! __('reservations.bill_approved_services') !!} </span>
                                                </th>
                                                <td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                            @foreach($servicesAndAddedService['services'] as $oneSer)
                                                <?php
                                                /** @var TYPE_NAME $oneSer */
                                                $servicePrice = $oneSer['price']*$oneSer['quantity'];
                                                $serviceDiscount = ($servicePrice*$oneSer['discount_percentage'])/100;
                                                $serviceRemaining = $servicePrice-$serviceDiscount;

                                                ?>
                                                <tr class="day_color1">
                                                    <th scope="row">
                                                        <span> {{$oneSer['name']}} </span>
                                                    </th>
                                                    <td>{{$oneSer['quantity']}}</td>
                                                    <td>{{$oneSer['price'] . ' ' . $sar}} </td>
                                                    <td>{{$servicePrice . ' ' . $sar}}</td>
                                                    <td>{{$serviceDiscount . ' ' . $sar}}</td>
                                                    <td>{{$serviceRemaining . ' ' . $sar}} </td>
                                                </tr>
                                            @endforeach

                                        @endif
                                        @if(($servicesAndAddedService['added_services'] ?? null))
                                            <tr class="day_color1">
                                                <th scope="row">
                                                    <span class=""> {!! __('reservations.bill_added_services') !!} </span>
                                                </th>
                                                <td></td><td></td><td></td><td></td><td></td>
                                            </tr>
                                            @foreach($servicesAndAddedService['added_services'] as $oneAddedSer)
                                                <?php
                                                /** @var TYPE_NAME $oneAddedSer */
                                                $addedServicePrice = $oneAddedSer['price']*$oneAddedSer['quantity'];
                                                $addedServiceDiscount = ($addedServicePrice*$oneAddedSer['discount_percentage'])/100;
                                                $addedServiceRemaining = $addedServicePrice-$addedServiceDiscount;

                                                ?>
                                                <tr class="day_color1">
                                                    <th scope="row">
                                                        <span> {{$oneAddedSer['name']}} </span>
                                                    </th>
                                                    <td>{{$oneAddedSer['quantity']}}</td>
                                                    <td>{{$oneAddedSer['price'] . ' ' . $sar}} </td>
                                                    <td>{{$addedServicePrice . ' ' . $sar}}</td>
                                                    <td>{{$addedServiceDiscount . ' ' . $sar}}</td>
                                                    <td>{{$addedServiceRemaining . ' ' . $sar}} </td>
                                                </tr>
                                            @endforeach
                                        @endif
                                    @endforeach

                                @else
                                    @foreach($reservationDays['days'] as $key => $reservationDay)
                                        <?php
                                        /** @var TYPE_NAME $reservation */
                                        /** @var TYPE_NAME $reservationDays */
                                        /** @var TYPE_NAME $day */
                                        /** @var TYPE_NAME $key */
                                        /** @var TYPE_NAME $reservationDay */

                                        $reservationPrice = ($reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person);
                                        $discountPercentage = $reservationDays['percentage'][$key];
                                        $count = $hall->reservation_type == 'person_count' ? $reservation->person_count : 1;
                                        $total = ($reservationPrice*$count);
                                        $discount = ($total*$discountPercentage)/100;
                                        $remaining = $total-$discount;
                                        $sar = __('reservations.sar');
                                        ?>
                                        <tr class="day_back">
                                            <th scope="row" class="day_back">
                                                <span class=""> {{__('reservations.day')}} {{dateInfo($reservationDay, ['day_name' => true])}} {{__('reservations.corresponding_to')}} ({{dateInfo($reservationDay, ['format' => 'Y / m / d'])}}) </span>
                                            </th>
                                            <td>
                                                {{$count}}
                                            </td>
                                            <td>{{$reservationPrice . ' ' . $sar}} </td>
                                            <td>{{$total . ' ' . $sar}} </td>
                                            <td>{{$discount . ' ' . $sar}} </td>
                                            <td>{{$remaining . ' ' . $sar}} </td>

                                        </tr>
                                    @endforeach
                                @endif


                                {{-- Start Bill footer--}}
                                <tr>
                                    <th scope="row" class="day_back_dark">
                                        <span>{!! __('reservations.bill_total_before_tax') !!}</span>
                                    </th>
                                    <td colspan="5" class="text-center">
                                        {{$totalBeforeAddedValue . ' ' . __('reservations.sar')}}
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row" class="day_back_dark">
                                        <span>{!! __('reservations.bill_added_value') !!}</span>
                                    </th>
                                    <td colspan="5" class="text-center">
                                        {{($settings['added_value'] ?? 0)}}%
                                    </td>
                                </tr>
                                <tr>
                                    <th scope="row" class="day_back_dark">
                                        <span>{!! __('reservations.bill_total_after_tax') !!}</span>
                                    </th>
                                    <td colspan="5" class="text-center">
                                        {{$totalAfterAddedValue . ' ' . __('reservations.sar')}}
                                    </td>
                                </tr>
                                {{--                                <tr>--}}
                                {{--                                    <th scope="row" class="day_back_dark">--}}
                                {{--                                        <span>{{__('reservations.site_percentage')}}</span>--}}
                                {{--                                    </th>--}}
                                {{--                                    <td colspan="4">--}}
                                {{--                                    </td>--}}
                                {{--                                    <td>--}}
                                {{--                                        {{$sitePercentageValue}} {{'(' . ($settings['website_percentage'] ?? 0) . ')' . '%'}}--}}
                                {{--                                    </td>--}}
                                {{--                                </tr>--}}
                                {{-- End Bill footer--}}
                                </tbody>
                            </table>
                        </div>
                        <div class="col-md-12">
                            <label>{{__('reservations.other_details')}}</label>
                            <textarea class="form-control" cols="30" rows="10">{{$reservation->other_details}}</textarea>
                        </div>
                        {{-- Payment block--}}
                        @if($hall->reservation_way == 'direct' || $reservation->re_status == 'waiting_for_pay')
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.finishPay', $reservation->id)}}" method="post" class="pay_now_form">
                                    <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.pay')}}</b></h4>
                                    <div class="cards-radio-btn mb-4">
                                        <div class="row">
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" style="cursor:pointer;" value="2" class="card-input-element" />
                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/visa.png')}}" alt="" class="pay-img">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" style="cursor:pointer;" value="2" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/master.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            @if($showApplePay)
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" style="cursor:pointer;" value="11" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/apple-pay2.png')}}" alt="" class="pay-img ">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" style="cursor:pointer;" value="14" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/stcpay-logo.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" style="cursor:pointer;" value="6" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/mada.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 pay_now_button" type="submit"> {{__('reservations.pay_now')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @else
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.sendReservationRequest', $reservation->id)}}" method="get" class="send_request_from">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 send_request_button" type="submit"> {{__('reservations.send_request')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        $('.pay_now_button, .send_request_button').click(async function (e) {
            e.preventDefault();

            // $(this).prop('disabled', true);
            let form = $('.pay_now_form');

            if ($(this).hasClass('send_request_button')){
                form = $('.send_request_from');
            }

            let data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                $(this).removeAttr('disabled');
                toasterError(response.errors);
            }
            if (response.url) {
                window.location.href = response.url;
            }
            if (response.send_request) {
                toasterSuccess(response.message);
                setTimeout(function () {
                    window.location.href = response.route;
                }, 200);

            }
        });
    </script>

@endsection

