@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{__('reservations.edit')}} </li>
                </ol>
                <h3> {{__('reservations.edit')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <section class="reservation_det reservation_det2 bill-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="swiper-container single-hall-swiper">
                        <div class="swiper-wrapper">
                            @if(count(json_decode($userReservation['images'])))
                                @foreach(json_decode($userReservation['images']) as $image)
                                    <div class="swiper-slide">
                                        <img src="{{asset($image)}}" alt="" class="hall-img">
                                    </div>
                                @endforeach
                            @endif
                        </div>
                        <!-- Add Arrows -->
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                    <div class="reservation_item">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="content">
                                    <h5 class="name mb-3"><b>{{$userReservation->hall_name}}</b></h5>
                                    <span class="data d-block"><b>{{$userReservation->category_name}}</b> <small class="num mr-1 ml-1">#{{$userReservation->re_no}}</small></span>
                                    <p class="data mt-2 "><i class="far fa-calendar-alt"></i> {{date('d-m-Y', strtotime($userReservation->re_date_from))}}</p>
                                    <p class="data"><i class="far fa-user"></i>{{__('halls.capacity')}} <b class="mr-1 ml-1">{{$userReservation->capacity}} {{__('members.persons')}}</b></p>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="left-data">
                                    @if($userReservation->re_status == 'confirmed') <span class="badge  badge_completed">{{__('reservations.confirmed')}}</span> @endif
                                    @if($userReservation->re_status == 'unconfirmed') <span class="badge  badge_uncertain">{{__('reservations.unconfirmed')}}</span> @endif
                                    @if($userReservation->re_status == 'waiting_for_pay') <span class="badge badge_pinding">{{__('reservations.waiting_for_pay')}}</span> @endif
                                    @if($userReservation->re_status == 'canceled') <span class="badge badge_canceled">{{__('reservations.canceled')}}</span> @endif
                                    @if($userReservation->re_status == 'finished') <span class="badge badge_expired">{{__('reservations.finished')}}</span> @endif
                                    @if($userReservation->re_status == 'reject') <span class="badge badge_canceled">{{__('reservations.reject')}}</span> @endif
                                    <h3 class="price mt-4 dir-l"><b>{{$userReservation->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="prof-info">
                                    <img src="{{asset('assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                    <div class="text">
                                        <span class="title">{{__('reservations.provider_name')}}</span>
                                        <h6 class="name mb-0">{{$userReservation->provider_name}}</h6>
                                    </div>
                                </div>
                            </div>
                            @if($userReservation->person_count)
                                <div class="col-md-3">
                                    <div class="prof-info">
                                        <img src="{{asset('assets/web/images/icons/team.svg')}}" alt="" class="prof_img user_icon">
                                        <div class="text">
                                            <span class="title">  {{__('reservations.person_count')}} </span>
                                            <h6 class="name mb-0"> {{$userReservation->person_count}} {{__('members.persons')}}  </h6>
                                        </div>
                                    </div>
                                </div>
                            @endif
                            @if($userReservation->re_status == 'confirmed')
                            <div class="col-md-3">
                                <button class="prof-info" data-toggle="modal" data-target="#modal_bill">
                                    <img src="{{asset('assets/web/images/icons/pdf.svg')}}" alt="" class="prof_img user_icon">
                                    <div class="text">
                                        <span class="title"> {{__('reservations.bill_file')}} </span>
                                        <h6 class="name mb-0"> file.pdf  </h6>
                                    </div>
                                </button>
                            </div>
                            @endif

                            <!-- Modal -->
                            <div class="modal fade modal_bill modal_new_bill cont_print" id="modal_bill" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered modal-xl" role="document">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLongTitle">{{__('reservations.bill_details')}}</h5>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <section class="mail_meet">
                                                <div class="cont">
                                                    <div class="content">
                                                        <div class="logo">
                                                            <img src="{{asset('assets/web/images/logo-footer.svg')}}" alt="">
                                                        </div>
                                                        <div class="top_inf">
                                                            <div class="r_side">
                                                                <h6>{{$userReservation->hall_name}}</h6>
                                                                <p>#{{$userReservation->re_no}}</p>
                                                                <div class="date">
                                                                    <img src="{{asset('assets/web/images/icons/Icon material-date-range.png')}}" alt="">
                                                                    <span>{{date('d M, Y', strtotime($userReservation->re_date_from))}}</span>
                                                                </div>
                                                            </div>
                                                            <div class="l_side">
                                                                <span class="butn">{{__('reservations.'.$userReservation->re_status)}}</span>
                                                                <div class="price">
                                                                    <strong>{{$userReservation->total}} </strong> <small>{{__('reservations.sar')}}</small>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="user_detials">
                                                            <ul>
                                                                <li>
                                                                    <div class="img">
                                                                        <img src="{{asset('assets/web/images/user.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.provider_name')}}</p>
                                                                        <h6>{{$userReservation->provider_name}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/1.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.person_count')}}</p>
                                                                        <h6> {{$userReservation->person_count}} <small>{{__('reservations.person')}}</small></h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/2.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.address')}}</p>
                                                                        <h6>{{$userReservation->street}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/3.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.phone')}}</p>
                                                                        <h6>{{$userReservation->provider_phone}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/1.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.person_name_charge')}}</p>
                                                                        <h6>{{$userReservation->provider_name}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/1.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.user_name')}}</p>
                                                                        <h6>{{$userReservation->client_name}}</h6>
                                                                    </div>
                                                                </li>
                                                                <li>
                                                                    <div class="img">
                                                                        <img class="icon" src="{{asset('assets/web/images/icons/email.png')}}" alt="">
                                                                    </div>
                                                                    <div class="inf">
                                                                        <p>{{__('reservations.user_email')}}</p>
                                                                        <h6>{{$userReservation->client_email}}</h6>
                                                                    </div>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="center_title">
                                                            <span>{{$userReservation->reservation_type == 'person_count' ? __('halls.booking_amount_per_person') : __('halls.booking_amount_per_day')}}</span>
                                                            <span class="price">
                                                            <strong>{{$userReservation->booking_amount_per_person ?? $userReservation->booking_amount_per_day}} </strong> <small>{{__('reservations.sar')}}</small>
                                                        </span>
                                                            <span>
                                                            <small>X</small> <img src="{{asset('assets/web/images/icons/1.png')}}" alt=""> <small>{{$userReservation->person_count}}</small> {{__('reservations.person')}}
                                                        </span>
                                                        </div>

                                                        <div class="services">
                                                            <div class="center_title">
                                                                <span>{{__('halls.approved_services')}} </span> <a href="#">{{__('halls.meet')}}</a>
                                                            </div>
                                                            <div class="ser_content">
                                                                @if(count($services))
                                                                    @foreach($services as $service)
                                                                        <div class="ser_items">
                                                                            <h6>{{$service['name']}}</h6>
                                                                            <span class="price">
                                                                            <strong>{{$service['price']}} </strong> <small>{{__('reservations.sar')}}</small>
                                                                        </span>
                                                                        </div>
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                            <div class="center_title">
                                                                <span>{{__('reservations.added_services_amount')}}</span>
                                                            </div>
                                                            <div class="ser_content">
                                                                @if(count($addedServices))
                                                                    @foreach($addedServices as $addedService)
                                                                        <div class="ser_items">
                                                                            <h6>{{$addedService['name']}}</h6>
                                                                            <span class="price">
                                                                    <strong>{{$addedService['price']}} </strong> <small>{{__('reservations.sar')}}</small>
                                                                </span>
                                                                        </div>
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                        </div>
                                                        <div class="center_title bold mt_8">
                                                            <span>{{__('reservations.added_value_amount')}} <strong class="main_color">({{$addedValue}}%)</strong> </span>
                                                        </div>
                                                        <div class="price text-center">
                                                            <strong>{{$userReservation->added_value_amount}} </strong> <small>{{__('reservations.sar')}}</small>
                                                        </div>
                                                        <div class="center_title bold mt_8">
                                                            <span> <strong class="main_color">{{__('reservations.total')}}</strong> </span>
                                                        </div>
                                                        <div class="price text-center">
                                                            <strong>{{$userReservation->total}} </strong> <small>{{__('reservations.sar')}}</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </section>
                                        </div>
                                        <div class="modal-footer">
                                            <button id="print_btn" href="#0" type="button" class="btn btn-secondary bg-success">{{__('reservations.print')}}</button>
                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('reservations.close')}}</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <h5 class="headline mt-5 mb-4"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{__('halls.hall_location')}}</h5>
                            </div>
                            <div class="col-md-6">
                                <div class="map-box">
                                    <iframe width="100%" height="350" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=1%20Grafton%20Street,%20Dublin,%20Ireland+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="hall_contacts center-vr">
                                    <p class="labeled"><img src="{{asset('assets/web/images/icons/loc-mouve.svg')}}" alt="" class="icon"> {{__('reservations.address')}}</p>
                                    <h6 class="data mb-4"><b>{{$userReservation->street}}</b></h6>
                                    <p class="labeled"><img src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="" class="icon"> {{__('halls.client_name')}}</p>
                                    <h6 class="data"><b>{{$userReservation->client_name}}</b></h6>
                                    <p class="labeled mt-4"><img src="{{asset('assets/web/images/icons/phone.svg')}}" alt="" class="icon"> {{__('halls.client_phone')}}</p>
                                    <h6 class="data"><b>{{$userReservation->client_phone}}</b></h6>
                                    <p class="labeled mt-4"><img src="{{asset('assets/web/images/icons/email.svg')}}" alt="" class="icon"> {{__('reservations.user_email')}}</p>
                                    <h6 class="data"><b>{{$userReservation->client_email}}</b></h6>
                                </div>
                            </div>
                            @if($userReservation->booking_amount_per_person)
                                <div class="text_reserv mt-5">
                                    <p class="p">{{__('halls.booking_amount_per_person')}}</p>
                                    <h4 class="price dir-l"><b>{{$userReservation->booking_amount_per_person}}</b> <small>{{__('main.sar')}}</small></h4>
                                    <p class="p mr-1 ml-1"><b>*</b> <i class="far fa-user"></i> <span class="dir-l">{{$userReservation->person_count}} {{__('members.persons')}}</span></p>
                                </div>
                            @endif

                            @if(count($services))
                            <div class="col-lg-12 m-auto" >
                                <h5 class="headline text-center mt-5 mb-4">  {{__('halls.approved_services')}} <b class="dir-l">{{__('halls.meet')}}</b></h5>
                                <div class="row justify-content-center">
                                    @foreach($services as $service)
                                        <div class="col-lg-4 col-md-6">
                                            <div class="serv_card">
                                                <div class="img-box">
                                                    <img src="{{asset($service['image'])}}" alt="" class="serv-img">
                                                </div>
                                                <div class="card-body">
                                                    <h6 class="title"><b>{{$service['name']}}</b></h6>
                                                    <p class="p">{{stripText($service['description'], 30)}}</p>
                                                    <h4 class="price dir-l mb-0"><b>{{$service['price']}}</b> <small>{{__('main.sar')}}</small></h4>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif


                            @if(count($addedServices))
                                <div class="col-md-12 mb-5">
                                    <h5 class="bill_title mt-5 mb-4">{{__('halls.added_services')}}</h5>
                                    <div class="row">
                                        <div class="col-lg-12 m-auto">
                                            <div class="row justify-content-center">
                                                @foreach($addedServices as $addedService)
                                                    <div class="col-lg-4 col-md-6">
                                                        <div class="serv_card">
                                                            <div class="img-box">
                                                                <img src="{{asset($addedService['image'])}}" alt="" class="serv-img">
                                                            </div>
                                                            <div class="card-body">
                                                                <h6 class="title"><b>{{$addedService['name']}}</b></h6>
                                                                <p class="p">{{stripText($addedService['description'], 30)}}</p>
                                                                <h4 class="price dir-l mb-0"><b>{{$addedService['price']}}</b> <small>{{__('main.sar')}}</small></h4>
                                                            </div>
                                                        </div>
                                                    </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endif

                            <div class="col-md-6">
                                <h5 class="bill_title mt-4 mb-4"> {{__('reservations.added_value_amount')}} <b class="tax dir-l">({{$addedValue}}%)</b></h5>
                                <h3 class="bill_title price dir-l mt-4 mb-4"><b>{{$userReservation->added_value_amount}}</b> <small>{{__('main.sar')}}</small></h3>
                            </div>
                            <div class="col-md-6">
                                <h5 class="bill_title mt-4 mb-4"> {{__('reservations.site_percentage')}}  <b class="tax dir-l">({{$sitePercentage}}%)</b></h5>
                                <h3 class="bill_title price dir-l mt-4 mb-4"><b>{{$sitePercentageAmount}}</b> <small>{{__('main.sar')}}</small></h3>
                            </div>
                            <div class="col-md-12 mt-5">
                                <div class="btns-wrapper">
                                    @if(time() < strtotime($userReservation->re_date_from))
                                        <a data-status="canceled" href="{{route('reservation.reservationStatusOperation', $userReservation->id)}}" class="butn refuse-butn reservation_operation_link"> {{__('reservations.cancel_reservation')}}</a>
                                        <a data-status="reject" href="{{route('reservation.reservationStatusOperation', $userReservation->id)}}" class="butn canceled-butn reservation_operation_link">{{__('reservations.reject_reservation')}} </a>
                                    @endif
                                    @if($userReservation->re_status == 'unconfirmed')
                                        <a data-status="waiting_for_pay" href="{{route('reservation.reservationStatusOperation', $userReservation->id)}}" class="butn accept-butn reservation_operation_link">{{__('reservations.accept_reservation')}}</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/reservations.provider_reservation_details.js') }}"></script>
    @include('web.members.append_fcm')
@endsection

