@extends('web.layouts.container')
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">  {{__('reservations.bill_summary')}} </li>
                </ol>
                <h3> {{__('reservations.bill_summary')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="reservation_det bill-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="reservation_item">
                        <h3 class="bill_title">{{__('reservations.bill_summary')}}</h3>
                        <div class="col-lg-12">
                            <h5 class="headline mt-5 mb-4"> {{__('reservations.edit')}} </h5>
                            <div class="table-responsive">
                                <table class="table table-bordered bill_table">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{__('reservations.description')}}</th>
                                        <th scope="col">{{__('reservations.quantity')}}</th>
                                        <th scope="col">{{__('reservations.unit_price')}}</th>
                                        <th scope="col">{{__('reservations.price_before_discount')}}</th>
                                        <th scope="col">{{__('reservations.price_after_discount')}}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($reservation->re_days['days'] as $key => $reDay)
                                        <tr>
                                            <th scope="row">
                                                <span> {{dateInfo($reDay, ['day_name' => true])}} {{__('reservations.corresponding_to')}} {{'('.dateInfo($reDay, ['format' => 'd / m / Y']).')'}} </span>
                                                @if($reservation->re_days['percentage'][$key])
                                                    <small class="bg-success"> {{__('reservations.discount')}} {{$reservation->re_days['percentage'][$key]}}% </small>
                                                @endif
                                            </th>
                                            <td>1</td>
                                            <td>
                                                {{$reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person}} {{__('reservations.sar')}}
                                            </td>
                                            <td>
                                                {{$reservation->booking_amount_per_day ?? $reservation->booking_amount_per_person}} {{__('reservations.sar')}}
                                            </td>
                                            <td>
                                                @if($reservation->booking_amount_per_day) {{$reservation->booking_amount_per_day - (($reservation->booking_amount_per_day*$reservation->re_days['percentage'][$key])/100)}} @endif
                                                @if($reservation->booking_amount_per_person) {{$reservation->booking_amount_per_person - (($reservation->booking_amount_per_person*$reservation->re_days['percentage'][$key])/100)}} @endif
                                                {{__('reservations.sar')}}
                                            </td>
                                        </tr>
                                    @endforeach

                                    @if(count($services))
                                        @foreach($services as $service)
                                            <tr>
                                                <th scope="row">
                                                    <span>{{__('reservations.services')}}</span>
                                                    <small> {{$service['name']}} </small>
                                                </th>
                                                <td>1</td>
                                                <td></td>
                                                <td>
                                                    400 ريال
                                                </td>
                                                <td>
                                                    390 ريال
                                                </td>
                                            </tr>
                                        @endforeach
                                    @endif

                                    <tr>
                                        <th scope="row">
                                            <span>{{__('reservations.added_services')}}</span>
                                            <small> وجبات خفيفة </small>
                                        </th>
                                        <td>
                                            40
                                        </td>
                                        <td>
                                            100 ريال
                                        </td>
                                        <td>
                                            400 ريال
                                        </td>
                                        <td>
                                            390 ريال
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <span>{{__('reservations.total_before_tax')}}</span>
                                        </th>
                                        <td colspan="3">
                                        </td>
                                        <td>
                                            390 ريال
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <span>{{__('reservations.added_value_amount')}}</span>
                                        </th>
                                        <td colspan="3">
                                        </td>
                                        <td>{{$addedValue}} %</td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <span>{{__('reservations.total_after_tax')}}</span>
                                        </th>
                                        <td colspan="3">
                                        </td>
                                        <td>
                                            450 ريال
                                        </td>
                                    </tr>
                                    <tr>
                                        <th scope="row">
                                            <span>{{__('reservations.site_percentage')}}</span>
                                        </th>
                                        <td colspan="3">
                                        </td>
                                        <td>{{$sitePercentage}} %</td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        {{-- Payment block--}}
                        @if($hall->reservation_way == 'direct' || $reservation->re_status == 'waiting_for_pay')
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.finishPay', $reservation->id)}}" method="post" class="pay_now_form">
                                    <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.pay')}}</b></h4>
                                    <div class="cards-radio-btn mb-4">
                                        <div class="row">
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="2" class="card-input-element" />
                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/visa.png')}}" alt="" class="pay-img">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="2" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/master.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="11" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/apple-pay2.png')}}" alt="" class="pay-img ">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="14" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/stcpay-logo.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="6" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/mada.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 pay_now_button" type="submit"> {{__('reservations.pay_now')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @else
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.sendReservationRequest', $reservation->id)}}" method="get" class="send_request_from">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 send_request_button" type="submit"> {{__('reservations.send_request')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        $('.pay_now_button, .send_request_button').click(async function (e) {
            e.preventDefault();

            // $(this).prop('disabled', true);
            let form = $('.pay_now_form');

            if ($(this).hasClass('send_request_button')){
                form = $('.send_request_from');
            }

            let data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                $(this).removeAttr('disabled');
                toasterError(response.errors);
            }
            if (response.url) {
                window.location.href = response.url;
            }
            if (response.send_request) {
                toasterSuccess(response.message);
                setTimeout(function () {
                    window.location.href = response.route;
                }, 200);

            }
        });
    </script>

@endsection

