@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">  {{__('reservations.bill_summary')}} </li>
                </ol>
                <h3> {{__('reservations.bill_summary')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="reservation_det bill-pg">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 m-auto">
                    <div class="reservation_item">
                        <h3 class="bill_title">{{__('reservations.bill_summary')}}</h3>
                        @if($reservation->person_count)
                            <div class="text_reserv mt-4">
                                <p class="p">{{__('halls.booking_amount_per_person')}}</p>
                                <h4 class="price dir-l"><b>{{$hall->booking_amount_per_person}}</b> <small>{{__('main.sar')}}</small></h4>
                                <p class="p mr-1 ml-1"><b>*</b> <i class="far fa-user"></i> <span class="dir-l">{{$reservation->person_count}} {{__('members.persons')}}</span></p>
                            </div>
                            <div class="text_reserv">
                                <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.total')}}</b></h4>
                                <h2 class="bill_title price dir-l mt-4 mb-4"><b>{{round($reservation->person_count*$reservation->booking_amount_per_person)}}</b> <small>{{__('main.sar')}}</small></h2>
                            </div>
                        @endif
                        @if($reservation->reservation_type == 'days_count')
                            <div class="text_reserv mt-4">
                                <p class="p">{{__('halls.booking_amount_per_day')}}</p>
                                <h4 class="price dir-l"><b>{{$hall->booking_amount_per_day}}</b> <small>{{__('main.sar')}}</small></h4>
                                <p class="p mr-1 ml-1"><b>*</b> <i class="far fa-calendar-times"></i> <span class="dir-l">{{count($reservation->re_days)}} {{__('members.days')}}</span></p>
                            </div>
                            <div class="text_reserv">
                                <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.total')}}</b></h4>
                                <h2 class="bill_title price dir-l mt-4 mb-4"><b>{{round(count($reservation->re_days)*$reservation->booking_amount_per_day)}}</b> <small>{{__('main.sar')}}</small></h2>
                            </div>
                        @endif
                        <p class="date text-center ">{{__('members.from')}} <b>{{date('Y M d', strtotime($reservation->re_date_from))}}</b> {{__('members.to')}} <b>{{date('Y M d', strtotime($reservation->re_date_to))}}</b></p>
                        @if(count($services))
                            <h5 class="bill_title mt-4 mb-4">{{__('halls.approved_services') . __('halls.meet')}}</h5>
                            <div class="row justify-content-center">
                                @foreach($services as $service)
                                    <div class="col-lg-4 col-md-6">
                                        <div class="serv_card">
                                            <div class="img-box">
                                                <img src="{{asset($service['image'])}}" alt="" class="serv-img">
                                            </div>
                                            <div class="card-body">
                                                <h6 class="title"><b>{{$service['name']}}</b></h6>
                                                <p class="p">{{stripText($service['description'], 30)}}</p>
                                                <h4 class="price dir-l mb-0"><b>{{$service['price']}}</b> <small>{{__('main.sar')}}</small></h4>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <div class="text_reserv">
                                <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.total')}}</b></h4>
                                <h2 class="bill_title price dir-l mt-4 mb-4"><b>{{$servicesTotal}}</b> <small>{{__('main.sar')}}</small></h2>
                            </div>
                        @endif
                        @if(count($addedServices))
                        <h5 class="bill_title mt-4 mb-4">{{__('halls.added_services')}}</h5>
                        <div class="row justify-content-center">
                            @foreach($addedServices as $addedService)
                                <div class="col-lg-4 col-md-6">
                                    <div class="serv_card">
                                        <div class="img-box">
                                            <img src="{{asset($addedService['image'])}}" alt="" class="serv-img">
                                        </div>
                                        <div class="card-body">
                                            <h6 class="title"><b>{{$addedService['name']}}</b></h6>
                                            <p class="p">{{stripText($addedService['description'], 30)}}</p>
                                            <h4 class="price dir-l mb-0"><b>{{$addedService['price']}}</b> <small>{{__('main.sar')}}</small></h4>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                            <div class="text_reserv">
                                <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.total')}}</b></h4>
                                <h2 class="bill_title price dir-l mt-4 mb-4"><b>{{$addedServiceTotal}}</b> <small>{{__('main.sar')}}</small></h2>
                            </div>
                        @endif
                        <h5 class="bill_title mt-4 mb-4"> {{__('reservations.added_value_amount')}} <b class="tax dir-l">( {{$addedValue}}%)</b></h5>
                        <h3 class="bill_title price dir-l mt-4 mb-4"><b>{{round($reservation->added_value_amount)}}</b> <small>{{__('main.sar')}}</small></h3>
                        <hr>
                        @if($discountAmount)
                            <h5 class="bill_title mt-4 mb-4"> {{__('reservations.discount_amount')}} <b class="tax dir-l">( {{$discountPercentage}}%)</b></h5>
                            <h3 class="bill_title price dir-l mt-4 mb-4"><b>{{round($discountAmount)}}</b> <small>{{__('main.sar')}}</small></h3>
                            <hr>
                        @endif

                        <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.total')}}</b></h4>
                        <h2 class="bill_title price dir-l mt-4 mb-4"><b>{{round($reservation->total)}}</b> <small>{{__('main.sar')}}</small></h2>
                        @if($hall->reservation_way == 'direct' || $reservation->re_status == 'waiting_for_pay')
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.finishPay', $reservation->id)}}" method="post" class="pay_now_form">
                                    <h4 class="bill_title mt-4 mb-4"><b class="tax">{{__('reservations.pay')}}</b></h4>
                                    <div class="cards-radio-btn mb-4">
                                        <div class="row">
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="2" class="card-input-element" />
                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/visa.png')}}" alt="" class="pay-img">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="2" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/master.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="11" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/apple-pay2.png')}}" alt="" class="pay-img ">
                                                        </div>
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="14" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/stcpay-logo.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                            <div class="col-6 col-lg-4">
                                                <div class="radio-card">
                                                    <label>
                                                        <input type="radio" name="pay_way" value="6" class="card-input-element" />

                                                        <div class="panel panel-default card-input">
                                                            <img src="{{asset('assets/web/images/pay/mada.png')}}" alt="" class="pay-img">
                                                        </div>

                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 pay_now_button" type="submit"> {{__('reservations.pay_now')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @else
                            <div class="form-wrapper pt-5 mt-5">
                                <form action="{{route('reservation.sendReservationRequest', $reservation->id)}}" method="get" class="send_request_from">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <button class="submit-butn mt-4 send_request_button" type="submit"> {{__('reservations.send_request')}} </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>

    <script>
        $('.pay_now_button, .send_request_button').click(async function (e) {
            e.preventDefault();

            // $(this).prop('disabled', true);
            let form = $('.pay_now_form');

            if ($(this).hasClass('send_request_button')){
                form = $('.send_request_from');
            }

            let data = new FormData(form[0]),
                url = form.attr('action'),
                method = form.attr('method');

            const response=await ajax({
                url,
                data,
                dataType: 'json',
                method,
                contentType: false,
                processData: false,
            });

            if (response.errors) {
                $(this).removeAttr('disabled');
                toasterError(response.errors);
            }
            if (response.url) {
                window.location.href = response.url;
            }
            if (response.send_request) {
                toasterSuccess(response.message);
                setTimeout(function () {
                    window.location.href = response.route;
                }, 200);

            }
        });
    </script>

@endsection

