@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{$title ?? ''}} </li>
                </ol>
                <h3>{{$title ?? ''}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <section class="profile-pg">
        <div class="container">
            <div class="row">
                @include('web.members.users.include.profile_side')

                <div class="col-lg-9 m-auto">
                    <div class="tab-content" id="v-pills-tabContent">
                        @include('web.members.users.include.profile')
                        @include('web.members.users.include.reservations')
                        @include('web.members.users.include.notifications')
                    </div>
                </div>
            </div>
        </div>
    </section>
    <div class="modal info-modal fade" id="infoModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel">{{__('members.edit_profile')}}</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <form action="{{route('user.updateProfile', $user)}}" method="post" class="update_profile_form">
                    <div class="modal-body form-wrapper">
                        <div class="image-container" id="imagePreview" style="background-image: url({{asset($user->photo ?? $logo)}});">
                            <input type="file" name="photo" class="custom-file-input" id="imageUpload" required="" capture="">
                            <button><i class="far fa-edit"></i></button>
                        </div>
                        <div class="row mt-5">
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <input type="text" name="name" class="form-control" autocomplete="off" autofocus required value="{{$user->name}}" />
                                    <label class="floating-label"> {{__('members.name')}} </label>
                                </div>
                            </div>
                            <div class="col-lg-4">
                                <div class="form-group">
                                    <input type="email" name="email" class="form-control" autocomplete="off" autofocus required value="{{$user->email}}" />
                                    <label class="floating-label"> {{__('members.email')}} </label>
                                </div>
                            </div>

                            <div class="col-lg-4">
                                <div class="form-group">
                                    <input type="tel" name="phone" class="form-control" autocomplete="off" autofocus required value="{{$user->phone}}" />
                                    <label class="floating-label"> {{__('members.phone')}} </label>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group show_hide_password">
                                    <input type="password" name="password" class="form-control"  id="password"  autocomplete="off" autofocus required />
                                    <label class="floating-label">{{__('members.password')}}</label>
                                    <!--<span class="togglePassword"><i class="far fa-eye" id="togglePassword"></i></span>-->
                                    <i class="show_pass far fa-eye-slash"></i>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group show_hide_password">
                                    <input type="password" name="password_confirmation" class="form-control"  autocomplete="off" autofocus required />
                                    <label class="floating-label"> {{__('members.retype_password')}} </label>
                                    <i class="show_pass far fa-eye-slash"></i>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="custom-control custom-control_3 custom-checkbox mt-3">
                                    <input value="1" name="email_receive" type="checkbox" class="custom-control-input" id="newsletter">
                                    <label class="custom-control-label" for="newsletter">{{__('members.email_receive')}}</label>
                                </div>
                            </div>

                        </div>
                    </div>
                </form>

                <div class="modal-footer">
                    <button type="button" class="main-butn update_profile_button" ><i class="fas fa-save"></i> {{__('members.save')}}</button>
                </div>

            </div>

        </div>

    </div>
    <!-- infoSavedSuccess Modal -->
    <div class="modal fade infoSaved" id="infoSavedSuccess" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
          <div class="modal-body text-center">
                <h2 class="icon mb-4">
                    <i class="fas fa-check text-success"></i>
                </h2>
                <h3 class="title mb-4">
                    {{__('members.save_successfully')}}
                </h3>

                <div class="text-center">
                    <button type="button" class="btn btn-danger rounded-pill px-4 m-2" data-dismiss="modal" aria-label="Close">اغلاق</button>
                </div>
          </div>
        </div>
      </div>
    </div>
    <!--rate Modal-->
    <div class="modal rate-modal fade rateModal" id="rateModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="staticBackdropLabel"> {{__('members.share_review')}} </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                </div>
                <div class="modal-body">
                    <div class="form-wrapper">
                        <form class="evaluate_form">
                            <div class="row">
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.cleaning')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="cleaning_5" name="cleaning" value="5" />
                                            <label for="cleaning_5" class="star">&#9733;</label>
                                            <input type="radio" id="cleaning_4" name="cleaning" value="4" />
                                            <label for="cleaning_4" class="star">&#9733;</label>
                                            <input type="radio" id="cleaning_3" name="cleaning" value="3" />
                                            <label for="cleaning_3" class="star">&#9733;</label>
                                            <input type="radio" id="cleaning_2" name="cleaning" value="2" />
                                            <label for="cleaning_2" class="star">&#9733;</label>
                                            <input type="radio" id="cleaning_1" name="cleaning" value="1" />
                                            <label for="cleaning_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.services')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="services_5" name="services" value="5" />
                                            <label for="services_5" class="star">&#9733;</label>
                                            <input type="radio" id="services_4" name="services" value="4" />
                                            <label for="services_4" class="star">&#9733;</label>
                                            <input type="radio" id="services_3" name="services" value="3" />
                                            <label for="services_3" class="star">&#9733;</label>
                                            <input type="radio" id="services_2" name="services" value="2" />
                                            <label for="services_2" class="star">&#9733;</label>
                                            <input type="radio" id="services_1" name="services" value="1" />
                                            <label for="services_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.staffs')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="staffs_5" name="staffs" value="5" />
                                            <label for="staffs_5" class="star">&#9733;</label>
                                            <input type="radio" id="staffs_4" name="staffs" value="4" />
                                            <label for="staffs_4" class="star">&#9733;</label>
                                            <input type="radio" id="staffs_3" name="staffs" value="3" />
                                            <label for="staffs_3" class="star">&#9733;</label>
                                            <input type="radio" id="staffs_2" name="staffs" value="2" />
                                            <label for="staffs_2" class="star">&#9733;</label>
                                            <input type="radio" id="staffs_1" name="staffs" value="1" />
                                            <label for="staffs_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.comforts')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="comforts_5" name="comforts" value="5" />
                                            <label for="comforts_5" class="star">&#9733;</label>
                                            <input type="radio" id="comforts_4" name="comforts" value="4" />
                                            <label for="comforts_4" class="star">&#9733;</label>
                                            <input type="radio" id="comforts_3" name="comforts" value="3" />
                                            <label for="comforts_3" class="star">&#9733;</label>
                                            <input type="radio" id="comforts_2" name="comforts" value="2" />
                                            <label for="comforts_2" class="star">&#9733;</label>
                                            <input type="radio" id="comforts_1" name="comforts" value="1" />
                                            <label for="comforts_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.financial_value')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="financial_value_5" name="financial_value" value="5" />
                                            <label for="financial_value_5" class="star">&#9733;</label>
                                            <input type="radio" id="financial_value_4" name="financial_value" value="4" />
                                            <label for="financial_value_4" class="star">&#9733;</label>
                                            <input type="radio" id="financial_value_3" name="financial_value" value="3" />
                                            <label for="financial_value_3" class="star">&#9733;</label>
                                            <input type="radio" id="financial_value_2" name="financial_value" value="2" />
                                            <label for="financial_value_2" class="star">&#9733;</label>
                                            <input type="radio" id="financial_value_1" name="financial_value" value="1" />
                                            <label for="financial_value_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label class="label">{{__('halls.location')}}</label>
                                    <div class="stars-content">
                                        <div class="star-rating">
                                            <input type="radio" id="location_5" name="location" value="5" />
                                            <label for="location_5" class="star">&#9733;</label>
                                            <input type="radio" id="location_4" name="location" value="4" />
                                            <label for="location_4" class="star">&#9733;</label>
                                            <input type="radio" id="location_3" name="location" value="3" />
                                            <label for="location_3" class="star">&#9733;</label>
                                            <input type="radio" id="location_2" name="location" value="2" />
                                            <label for="location_2" class="star">&#9733;</label>
                                            <input type="radio" id="location_1" name="location" value="1" />
                                            <label for="location_1" class="star">&#9733;</label>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12">
                                    <label class="label">{{__('halls.comment')}}</label>
                                    <div class="form-group">
                                        <textarea name="comment" class="form-control" rows="8"></textarea>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="main-butn evaluate_button"><i class="fas fa-save"></i> {{__('members.save')}} </button>
                </div>
            </div>
        </div>
    </div>

    <!--Confirmation Modal-->
    <div class="modal state-modal fade" id="confirmationModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                <div class="modal-body">
                    <div class="text-box">
                        <img src="{{asset('assets/web/images/question.png')}}" alt="" class="icon mb-4"/>
                        <h3 class="title mb-3"> {{__('members.cancel_reservation_confirmation')}} </h3>
                        <p class="p"> {{__('members.cancel_reservation_confirmation_hint')}} <b>{{__('members.meet')}}</b> </p>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('members.cancel')}}</button>
                    <button type="button" class="main-butn cancel_reservation_modal_button"> {{__('members.sure')}} </button>
                </div>

            </div>

        </div>

    </div>


        <!-- Modal -->
        <div class="modal fade logoutModal" id="logoutModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
              <div class="modal-body text-center">
                    <span class="icon">
                        <i class="fas fa-sign-out-alt"></i>
                    </span>
                    <h3 class="title mb-4">
                        {{__('members.logout_alert')}}
                    </h3>

                    <div class="text-center">
                        <a href="{{route('userProvider.logout')}}" type="button" class="btn btn-danger rounded-pill px-4 m-2">{{__('members.yes')}}</a>
                        <button type="button" class="btn btn-light rounded-pill px-4 m-2" data-dismiss="modal" aria-label="Close" >{{__('members.no')}}</button>
                    </div>
              </div>
            </div>
          </div>
        </div>

@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script>
            let refreshNotificationRoute = "{{route('user.refreshNotification')}}",
                markAsReadRoute = "{{route('user.markAsRead')}}",
                getStateRoute = "{{route('user.getState')}}",
                reservationSearchRoute = "{{route('user.reservationSearch')}}",
                deleteNotificationRoute = "{{route('user.markAsRead')}}",
                noData = "{{__('members.no_data')}}",
                notificationCount = "{{$notificationsCount}}";

    </script>
    <script src="{{ asset('assets/web/js/users.profile.js') }}"></script>

    <script>
        $('.notifications_link').click(function () {
            // $('.notification_counter').html('0')
        })
    </script>

    @include('web.members.append_fcm')
{{--    @if(session('fcm_notification'))--}}
{{--        @include('web.members.append_fcm')--}}
{{--        {{session()->forget('fcm_notification')}}--}}
{{--    @endif--}}

@endsection

