<div class="tab-pane fade" id="v-pills-tab3" role="tabpanel" aria-labelledby="v-pills-tab3-tab">
    <div class="tab-wrapper notifications notifications_container">
        @if(count($allNotifications))
            @foreach($allNotifications as $notification)

                <?php
                /** @var TYPE_NAME $notification */
                $class = null;
                $icon = 'noti-success.svg';
                if ($notification->notification_type == 'success'){
                    $class = null;
                    $icon = 'noti-success.svg';
                }
                if ($notification->notification_type == 'cancel'){
                    $class = 'canceledItem';
                    $icon = 'noti-canceled.svg';
                }
                if ($notification->notification_type == 'alert'){
                    $class = 'alertItem';
                    $icon = 'noti-alert.svg';
                }
                date_default_timezone_set('Asia/Riyadh');
                //                        date_default_timezone_set('Africa/Cairo');
                $now = \Carbon\Carbon::now();
                $notificationTime = \Carbon\Carbon::make($notification->created_at);
                //$seconds = $dtF->diff($dtT)->format('%y years %m months %a days, %h hours, %i minutes and %s seconds');
                $years = $now->diff($notificationTime)->format('%y');
                $months = $now->diff($notificationTime)->format('%m');
                $days = $now->diff($notificationTime)->format('%a');
                $hours = $now->diff($notificationTime)->format('%h');
                $minutes = $now->diff($notificationTime)->format('%i');
                $seconds = $now->diff($notificationTime)->format('%s');
                ?>
                <a href="{{($notification->page_link ?? '#')}}">
                    <div class="noti-item notification_item {{$class}}">
                        <div class="dateTime d-block">
                            <p class="p">
                                <i class="far fa-clock"></i>
                                <span class="noti-dateTime">
                                    <span class="time-start">
                                        {{$years ? $years . __('halls.years') : ' '}}
                                        {{$months ? $months . __('halls.months') : ' '}}
                                        {{$days ? $days . __('halls.day') : ' '}}
                                        {{$hours ? $hours . __('halls.hours') : ' '}}
                                        {{$minutes ? $minutes . __('halls.minutes') : __('halls.moments')}}
                                    </span>
                                    <span class="ago">
                                        {{__('halls.ago')}}
                                    </span>
                                </span>

                            </p>
                            <p class="p"><i class="far fa-calendar-alt"></i>{{date('M Y d', strtotime($notification->created_at))}}</p>
                        </div>
                        <div class="noti-body mt-4">
                            <img src="{{asset("assets/web/images/icons/profile/{$icon}")}}" alt="" class="icon">
                            <div class="text">
                                <h4 class="title">{{$notification->title}}</h4>
                                <p class="p">{{$notification->message}}</p>
                            </div>
                        </div>
                        <a data-notification="{{$notification->id}}" data-toggle="modal" href="#delete_notification_modal" class="deleteButton delete_notification"><i class="fas fa-times-circle"></i></a>
                    </div>
                </a>
            @endforeach
        @else
            <div class="alert alert-secondary text-danger text-center no_data_alert">{{__('members.no_data')}}</div>
    </div>
    @endif
</div>

<!-- Modal -->
<div class="modal fade delete_notification_modal" id="delete_notification_modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            {{--            <div class="modal-header">--}}
            {{--                <h5 class="modal-title" id="exampleModalLabel">Modal title</h5>--}}
            {{--                <button type="button" class="close" data-dismiss="modal" aria-label="Close">--}}
            {{--                    <span aria-hidden="true">&times;</span>--}}
            {{--                </button>--}}
            {{--            </div>--}}
            <div class="modal-body d-flex align-items-center flex-column">
                <i class="fa fa-exclamation-triangle fa-3x text-danger"></i><h2 class="mt-4">{{__('members.delete_notification_hint')}}</h2>
                <form method="get" action="" class="delete_notification_form"></form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary bg-secondary" data-dismiss="modal">{{__('members.close')}}</button>
                <button type="button" class="btn btn-danger confirm_delete_notification">{{__('members.delete')}}</button>
            </div>
        </div>
    </div>
</div>

