@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link rel="stylesheet" href="{{asset('assets/web/css/lib/image-uploader.min.css')}}" >
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{$title ?? ''}} </li>
                </ol>
                <h3>{{$title ?? ''}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>

    <!--Start profile-pg -->
    <section class="profile-pg profile-provider">
        <div class="container">
            <div class="row">
                @include('web.members.providers.include.profile_side')
                <div class="col-lg-9 m-auto">
                    @if($user->status && $user->contract_agreement)
                        <div class="tab-content" id="v-pills-tabContent">
                            @include('web.members.providers.include.profile')
                            @include('web.members.providers.include.reservations')
                            @include('web.members.providers.include.saving')
                            @include('web.members.providers.include.add_hall')
                            @include('web.members.providers.include.my_hall')
                            @include('web.members.providers.include.contract')
                            @include('web.members.providers.include.notifications')
                        </div>
                    @endif
                    @if($user->status && !$user->contract_agreement)
                        <div class="tab-content" id="v-pills-tabContent">
                            @include('web.members.providers.include.contract')
                        </div>
                    @endif
                    @if(!$user->status && !$user->contract_agreement)
                        <div class="tab-content" id="v-pills-tabContent">
                            <div class="alert alert-secondary text-danger text-center">{{__('members.register_data_review_message')}}</div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </section>
    @if($user->status && $user->contract_agreement)
        <!--Info Modal-->
        <div class="modal info-modal fade" id="infoModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="staticBackdropLabel">{{__('members.edit_profile')}}</h5><button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    </div>
                    <form action="{{route('provider.updateProfile', $user)}}" class="update_profile_form">
                        <div class="modal-body form-wrapper">
                            <div class="image-container" id="imagePreview" style="background-image: url({{asset($user->logo ?? 'assets/web/images/avatar2.png')}});">
{{--                                <input name="photo" type="file" class="custom-file-input" id="imageUpload" required="" capture="">--}}
{{--                                <button><i class="far fa-edit"></i></button>--}}
                            </div>
                            <div class="row mt-5">
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input name="name" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->name}}" />
                                        <label class="floating-label"> {{__('members.name')}} </label>
                                    </div>
                                </div>
                                <div class="col-lg-2">
                                    <div class="form-group">
                                        <select name="code" class="form-control">
                                            @if(count($countryCods))
                                                @foreach($countryCods as $code)
                                                    <option {{$user->code == $code ? 'selected' : ''}} value="{{$code}}">{{$code}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <input  name="phone" type="tel" class="form-control text-left" autocomplete="off" autofocus required value="{{$user->phone}}" dir="ltr" placeholder="05********"/>
                                        <label class="floating-label"> {{__('members.phone')}} </label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <select data-target=".for_profile" name="region_id" class="form-control for_profile" autocomplete="off" autofocus required >
                                            <option value=""> {{__('members.region_id')}} </option>
                                            @if(count($regions))
                                                @foreach($regions as $region)
                                                    <option {{$user->region_id == $region->id ? 'selected' : ''}} value="{{$region->id}}">{{$region->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <label class="floating-label">{{__('members.region_id')}}</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <select data-target=".for_profile" name="city_id" class="form-control for_profile" autocomplete="off" autofocus required >
                                            <option value=""> ا{{__('members.city_id')}} </option>
                                            @if(count($cities))
                                                @foreach($cities as $city)
                                                    <option {{$user->city_id == $city->id ? 'selected' : ''}} value="{{$city->id}}">{{$city->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <label class="floating-label">{{__('members.city_id')}}</label>
                                    </div>
                                </div>
                                <div class="col-lg-4">
                                    <div class="form-group">
                                        <select data-target=".for_profile" name="sector_id" class="form-control for_profile" autocomplete="off" autofocus required >
                                            <option value=""> {{__('members.sector_id')}} </option>
                                            @if(count($sectors))
                                                @foreach($sectors as $sector)
                                                    <option {{$user->sector_id == $sector->id ? 'selected' : ''}} value="{{$sector->id}}">{{$sector->name}}</option>
                                                @endforeach
                                            @endif
                                        </select>
                                        <label class="floating-label">{{__('members.sector_id')}}</label>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group">
                                        <input name="street" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->street}}"/>
                                        <label class="floating-label">{{__('members.street')}}</label>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group show_hide_password">
                                        <input name="password" type="password" class="form-control"  id="password"  autocomplete="off" autofocus required />
                                        <label class="floating-label">{{__('members.password')}}</label>
                                        <!--<span class="togglePassword"><i class="far fa-eye" id="togglePassword"></i></span>-->
                                        <i class="show_pass far fa-eye-slash"></i>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group show_hide_password">
                                        <input name="password_confirmation" type="password" class="form-control"  autocomplete="off" autofocus required />
                                        <label class="floating-label"> {{__('members.retype_password')}} </label>
                                        <i class="show_pass far fa-eye-slash"></i>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <div class="form-group file-input-group">
                                        <div class="wrap">
                                            <div class="file">
                                                <div class="logo_file_input file__input" id="file__input">
                                                    <input class="file__input--file" id="customLogoFile" type="file" name="logo" />
                                                    <label class="file__input--label" for="customLogoFile" data-text-btn="{{__('members.select')}}"> {{__('members.logo')}}  :</label>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-12">
                                    <h5 class="title_banking mb-4 mt-1">{{__('members.bank_account_info')}}</h5>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input name="bank_name" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->bank_acc_info['bank_name'] ?? null}}"/>
                                        <label class="floating-label">  {{__('members.bank_name')}} </label>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input name="iban" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->bank_acc_info['iban'] ?? null}}"/>
                                        <label class="floating-label"> {{__('members.iban')}}  </label>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input name="client_name" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->bank_acc_info['client_name'] ?? null}}"/>
                                        <label class="floating-label">  {{__('members.client_name')}} </label>
                                    </div>
                                </div>
                                <div class="col-lg-6">
                                    <div class="form-group">
                                        <input name="acc_no" type="text" class="form-control" autocomplete="off" autofocus required value="{{$user->bank_acc_info['acc_no'] ?? null}}"/>
                                        <label class="floating-label"> {{__('members.acc_no')}} </label>
                                    </div>
                                </div>
                            </div>
                            <div class="custom-control custom-checkbox mt-3 custom-control_3">
                                <input {{$user->email_receive ? 'checked' : ''}} value="1" name="email_receive" type="checkbox" class="custom-control-input" id="newsletter">
                                <label class="custom-control-label" for="newsletter">{{__('members.email_receive')}}</label>
                            </div>
                        </div>
                    </form>
                    <div class="modal-footer">
                        <button type="button" class="main-butn update_profile_button"><i class="fas fa-save"></i> {{__('members.save')}}</button>
                    </div>

                </div>

            </div>

        </div>
        <!-- Modal -->
        <div class="modal fade infoSaved update_profile_modal" id="infoSavedSuccess" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body text-center">
                        <h2 class="icon mb-4">
                            <i class="fas fa-check text-success"></i>
                        </h2>
                        <h3 class="title mb-4">{{__('members.save_successfully')}}</h3>

                        <div class="text-center">
                            <button type="button" class="btn btn-danger rounded-pill px-4 m-2" data-dismiss="modal" aria-label="Close">اغلاق</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--Confirmation Modal-->
        <div class="modal state-modal fade" id="confirmationModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg">
                <div class="modal-content">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
                    <div class="modal-body">
                        <div class="text-box">
                            <img src="{{asset('assets/web/images/question.png')}}" alt="" class="icon mb-4"/>
                            <h3 class="title mb-3"> {{__('members.cancel_reservation_confirmation')}} </h3>
                            <p class="p"> {{__('members.cancel_reservation_confirmation_hint')}} <b>{{__('members.meet')}}</b> </p>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">{{__('members.cancel')}}</button>
                        <button type="button" class="main-butn"> {{__('members.sure')}} </button>
                    </div>

                </div>

            </div>

        </div>
    @endif



    <!-- Modal -->
    <div class="modal fade logoutModal" id="logoutModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <span class="icon">
                        <i class="fas fa-sign-out-alt"></i>
                    </span>
                    <h3 class="title mb-4">
                        {{__('members.logout_alert')}}
                    </h3>

                    <div class="text-center">
                        <a href="{{route('userProvider.logout')}}" type="button" class="btn btn-danger rounded-pill px-4 m-2">{{__('members.yes')}}</a>
                        <button type="button" class="btn btn-light rounded-pill px-4 m-2" data-dismiss="modal" aria-label="Close" >{{__('members.no')}}</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('inner_js')
    <script>
        let refreshNotificationRoute = "{{route('user.refreshNotification')}}",
            markAsReadRoute = "{{route('user.markAsRead')}}",
            providerWalletSearchRoute = "{{route('provider.walletSearch')}}",
            {{--reservationSearchRoute = "{{route('provider.reservationSearch')}}",--}}
            getCityAndSectorRoute = "{{route('provider.getCityAndSector')}}",
            addServiceIcon = "{{asset('assets/web/images/icons/profile/add.svg')}}",
            region_name = "{{__('members.region_id')}}",
            city_name = "{{__('members.city_id')}}",
            sector_name = "{{__('members.sector_id')}}",
            unavailable_dates_to = "{{__('halls.unavailable_dates_to')}}",
            unavailable_dates_from = "{{__('halls.unavailable_dates_from')}}",
            discount_dates_to = "{{__('halls.discount_dates_to')}}",
            discount = "{{__('halls.discount')}}",
            discount_dates_from = "{{__('halls.discount_dates_from')}}",
            discount_dates = "{{__('halls.discount_dates')}}",
            discount_percentage = "{{__('halls.discount_percentage')}}",
            added_services = "{{__('halls.added_services')}}",
            added_services_name = "{{__('halls.added_services_name')}}",
            added_services_price = "{{__('halls.added_services_price')}}",
            added_services_description = "{{__('halls.added_services_description')}}",
            added_services_image = "{{__('halls.added_services_image')}}",
            upload_added_service_images = "{{__('halls.upload_added_service_images')}}",
            select = "{{__('members.select')}}",
            upload_hall_image = "{{__('halls.upload_hall_image')}}",
            paginatorUrlRoute = "{{route('provider.getWalletByPaginator').'?page='}}",
            deleteNotificationRoute = "{{route('user.markAsRead')}}",
            noData = "{{__('members.no_data')}}",
            inputName = 'images[]';

    </script>
    <script src="{{ asset('assets/web/js/provider.profile.js') }}"></script>
    <script src="{{ asset('assets/web/js/image_upload.js') }}"></script>
    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <script defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDpVcBEVHKN5-iO0-z5MoEeLLpfV18JZjg&callback=initMap"></script>


    <script>
        let marker,
            lat = 24.67755881183715,
            lng = 46.588410252964344;
        function initMap() {
            /** Map one block */
            let map = new google.maps.Map(document.querySelector(".map"), {
                zoom: 6,
                center: { lat: lat , lng: lng }
            });

            let marker_1 = new google.maps.Marker({
                map: map,
                draggable: true,
                animation: google.maps.Animation.DROP,
                position: { lat: lat , lng: lng }
            });

            marker_1.addListener("dragend", function (map) {
                let lat = map.latLng.lat(), lng = map.latLng.lng();
                localStorage.setItem('lat', lat);
                localStorage.setItem('lng', lng);
                $('.lat_1').val(lat);
                $('.lng_1').val(lng);
                var geocoder = new google.maps.Geocoder();
                var infowindow = new google.maps.InfoWindow();

                google.maps.event.addListener(marker_1, 'dragend', function() {
                    infowindow.close();
                });

                var latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };
                geocoder.geocode({ location: latlng }, function(results, status) {
                    if (status === "OK") {
                        if (results[0]) {
                            infowindow.setContent(results[0].formatted_address);
                            infowindow.open(map, marker_1);
                            $('.street_1').val(results[0].formatted_address);
                        } else {
                            window.alert("No results found");
                        }
                    } else {
                        window.alert("Geocoder failed due to: " + status);
                    }
                });
                if (marker_1.getAnimation() !== null) {
                    marker_1.setAnimation(null);
                } else {
                    marker_1.setAnimation(google.maps.Animation.BOUNCE);
                }
            });

            /** <ap two block */
            let map_2 = new google.maps.Map(document.getElementById("map_2"), {
                zoom: 6,
                center: { lat: lat, lng: lng }
            });

            let marker_2 = new google.maps.Marker({
                map: map_2,
                draggable: true,
                animation: google.maps.Animation.DROP,
                position: { lat: lat , lng: lng }
            });

            marker_2.addListener("dragend", function (map) {
                let lat = map.latLng.lat(), lng = map.latLng.lng();
                localStorage.setItem('lat', lat);
                localStorage.setItem('lng', lng);
                $('.lat_2').val(lat);
                $('.lng_2').val(lng);
                var geocoder = new google.maps.Geocoder();
                var infowindow = new google.maps.InfoWindow();

                google.maps.event.addListener(marker_2, 'dragend', function() {
                    infowindow.close();
                });

                var latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };
                geocoder.geocode({ location: latlng }, function(results, status) {
                    if (status === "OK") {
                        if (results[0]) {
                            infowindow.setContent(results[0].formatted_address);
                            infowindow.open(map, marker_2);
                            $('.street_2').val(results[0].formatted_address);
                        } else {
                            window.alert("No results found");
                        }
                    } else {
                        window.alert("Geocoder failed due to: " + status);
                    }
                });
                if (marker_2.getAnimation() !== null) {
                    marker_2.setAnimation(null);
                } else {
                    marker_2.setAnimation(google.maps.Animation.BOUNCE);
                }
            });
        }
    </script>

    <script>
        $('#print_bttn').on("click", function() {
            $('.contract_box').printThis({
                importCSS: true, // import parent page css
            });
        });
    </script>

    @include('web.members.append_fcm')
    {{--    @if(session('fcm_notification'))--}}
    {{--        @include('web.members.append_fcm')--}}
    {{--        {{session()->forget('fcm_notification')}}--}}
    {{--    @endif--}}

@endsection

