<div class="tab-pane fade" id="v-pills-tab5" role="tabpanel" aria-labelledby="v-pills-tab5-tab">
    <div class="tab-wrapper availability">
        <nav class="custom-nav">
            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                <a class="nav-link active" id="nav-arrivals1-tab" data-toggle="tab" href="#nav-arrivals1" role="tab" aria-controls="nav-arrivals1" aria-selected="true">{{__('members.arrivals')}}</a>
                <a class="nav-link" id="nav-departures1-tab" data-toggle="tab" href="#nav-departures1" role="tab" aria-controls="nav-departures1" aria-selected="false">{{__('members.departures')}}</a>
            </div>
        </nav>
        <div class="filtering mb-5 pt-2 mt-4 d-flex flex-column align-items-center ">
            <h5>{{__('members.date')}}</h5>
            <h5 class="date dir-l"> {{date('d', time()). ' ' .__('reservations.'. date('M', time())) . ', ' .  date('Y', time())}} <i class="fas fa-calendar-alt"></i></h5>
        </div>
        <div class="tab-content" id="nav-tabContent">
            <div class="tab-pane fade show active" id="nav-arrivals1" role="tabpanel" aria-labelledby="nav-arrivals1-tab">
                @if(count($arrivals))
                    @foreach($arrivals as $arrival)
                        <div class="avail_card">
                            <div class="avail_head">
                                <span class="reserv_code">#{{$arrival->re_no}}</span>
                                <h5 class="date dir-l"> {{date('d', strtotime($arrival->re_date_from)). ' ' .__('reservations.'. date('M', strtotime($arrival->re_date_from))) . ', ' .  date('Y', strtotime($arrival->re_date_from))}} <i class="fas fa-calendar-alt"></i></h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="d-block">
                                            <div class="content">
                                                <img src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="" class="icon">
                                                <div class="text">
                                                    <p class="labeled">{{__('members.provider_name')}}</p>
                                                    <h6 class="data"><b>{{$arrival->provider_name}}</b></h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-block">
                                            <div class="content">
                                                <img src="{{asset('assets/web/images/icons/phone.svg')}}" alt="" class="icon">
                                                <div class="text">
                                                    <p class="labeled">{{__('members.client_phone')}}</p>
                                                    <h6 class="data dir-l"><b>{{$arrival->client_phone}}</b></h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <a href="{{route('reservation.reservationDetails', $arrival->id)}}" class="reserv_btn center-vr">{{__('members.go_to_reservation')}}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
            <div class="tab-pane fade" id="nav-departures1" role="tabpanel" aria-labelledby="nav-departures1-tab">
                @if(count($departures))
                    @foreach($departures as $departure)
                        <div class="avail_card">
                            <div class="avail_head">
                                <span class="reserv_code">#{{$departure->re_no}}</span>
                                <h5 class="date dir-l"> {{date('d', strtotime($departure->re_date_to)). ' ' .__('reservations.'. date('M', strtotime($departure->re_date_to))) . ', ' .  date('Y', strtotime($departure->re_date_to))}} <i class="fas fa-calendar-alt"></i></h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-8">
                                        <div class="d-block">
                                            <div class="content">
                                                <img src="{{asset('assets/web/images/icons/user-2.svg')}}" alt="" class="icon">
                                                <div class="text">
                                                    <p class="labeled">{{__('members.provider_name')}}</p>
                                                    <h6 class="data"><b>{{$departure->provider_name}}</b></h6>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="d-block">
                                            <div class="content">
                                                <img src="{{asset('assets/web/images/icons/phone.svg')}}" alt="" class="icon">
                                                <div class="text">
                                                    <p class="labeled">{{__('members.client_phone')}}</p>
                                                    <h6 class="data dir-l"><b>{{$departure->client_phone}}</b></h6>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <a href="{{route('reservation.reservationDetails', $departure->id)}}" class="reserv_btn center-vr">{{__('members.go_to_reservation')}}</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @endif
            </div>
        </div>

    </div>
</div>
