<div class="tab-pane fade" id="v-pills-tab2" role="tabpanel" aria-labelledby="v-pills-tab2-tab">
    <div class="tab-wrapper reservations">
        <div class="filtering  mt-4">
            <h5>{{__('members.search_filter')}}</h5>
            <form action="{{route('provider.reservationSearch')}}" method="post" class="search_reservation_form">
                <div class="row mt-3">
                    <div class="col-lg-4 col-md-6">
                        <div class="form-group">
                            <label>{{__('reservations.re_date_from')}}</label>
                            <input name="re_date" class="form-control" type="date">
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <div class="form-group">
                            <label>{{__('reservations.re_no')}}</label>
                            <input name="re_no" class="form-control" type="text" placeholder="#12235">
                        </div>
                    </div>
                    <div class="col-lg-4 col-md-6">
                        <button class="submit-btn search_reservation_button"><i class="fas fa-search"></i></button>
                    </div>
                </div>
            </form>
            <div class="col-md-12 mt-5 results-wrapper d-none search_reservation_result_container">
                <h4 class="search-title mb-4">Search result</h4>
                <div class="search_reservation_result_container_body"></div>
            </div>
        </div>
        <ul class="nav nav-pills mb-3 mt-4" id="pills-tab" role="tablist">
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status active" id="pills-completed-tab" data-toggle="pill" href="#pills-completed" role="tab" aria-controls="pills-completed" aria-selected="true">{{__('reservations.confirmed_re')}}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status" id="pills-uncertain-tab" data-toggle="pill" href="#pills-uncertain" role="tab" aria-controls="pills-uncertain" aria-selected="false">{{__('reservations.unconfirmed_re')}}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status" id="pills-pinding-tab" data-toggle="pill" href="#pills-pinding" role="tab" aria-controls="pills-pinding" aria-selected="false">{{__('reservations.waiting_for_pay_re')}}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status" id="pills-expired-tab" data-toggle="pill" href="#pills-expired" role="tab" aria-controls="pills-expired" aria-selected="false">{{__('reservations.finished_re')}}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status" id="pills-canceled-tab" data-toggle="pill" href="#pills-canceled" role="tab" aria-controls="pills-canceled" aria-selected="false">{{__('reservations.canceled_re')}}</a>
            </li>
            <li class="nav-item" role="presentation">
                <a class="nav-link reservation_status" id="pills-daily-tab" data-toggle="pill" href="#pills-daily" role="tab" aria-controls="pills-daily" aria-selected="false">{{__('reservations.daily_reservations')}}</a>
            </li>
        </ul>
        <div class="tab-content mt-5" id="pills-tabContent">
            <div class="tab-pane fade show active" id="pills-completed" role="tabpanel" aria-labelledby="pills-completed-tab">
                @if(isset($reservations['confirmed']) && count($reservations['confirmed']))
                    @foreach($reservations['confirmed'] as $confirm)
                        <div class="reservation_item">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$confirm->id)}}">
                                        <img src="{{asset(json_decode($confirm->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$confirm->hall_name}}</b></h5>
                                        <span class="num">#{{$confirm->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($confirm->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$confirm->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$confirm->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge badge_completed">{{__('reservations.confirmed')}}</span>

                                </div>
                            </div>
{{--                            @if(time() < strtotime($confirm->re_date_from))--}}
{{--                                <a data-href="{{route('reservation.reservationStatusOperation', $confirm->id)}}" class="deleteButton cancel_reservation_button" type="button" data-toggle="modal" data-target="#confirmationModal">--}}
{{--                                    <i class="fas fa-times-circle"></i>--}}
{{--                                </a>--}}
{{--                            @endif--}}
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
            <div class="tab-pane fade" id="pills-uncertain" role="tabpanel" aria-labelledby="pills-uncertain-tab">
                @if(isset($reservations['unconfirmed']) && count($reservations['unconfirmed']))
                    @foreach($reservations['unconfirmed'] as $unconfirmed)
                        <div class="reservation_item deleted_reservation_{{$unconfirmed->re_no}}">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$unconfirmed->id)}}">
                                        <img src="{{asset(json_decode($unconfirmed->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$unconfirmed->hall_name}}</b></h5>
                                        <span class="num">#{{$unconfirmed->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($unconfirmed->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$unconfirmed->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$unconfirmed->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge  badge_uncertain">{{__('reservations.unconfirmed')}}</span>
                                </div>
                            </div>
{{--                            @if(time() < strtotime($unconfirmed->re_date_from))--}}
{{--                                <a data-href="{{route('reservation.reservationStatusOperation', $unconfirmed->id)}}" class="deleteButton cancel_reservation_button" type="button" data-toggle="modal" data-target="#confirmationModal">--}}
{{--                                    <i class="fas fa-times-circle"></i>--}}
{{--                                </a>--}}
{{--                            @endif--}}
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
            <div class="tab-pane fade" id="pills-pinding" role="tabpanel" aria-labelledby="pills-pinding-tab">
                @if(isset($reservations['waiting_for_pay']) && count($reservations['waiting_for_pay']))
                    @foreach($reservations['waiting_for_pay'] as $waiting_for_pay)
                        <div class="reservation_item deleted_reservation_{{$waiting_for_pay->re_no}}">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$waiting_for_pay->id)}}">
                                        <img src="{{asset(json_decode($waiting_for_pay->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$waiting_for_pay->hall_name}}</b></h5>
                                        <span class="num">#{{$waiting_for_pay->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($waiting_for_pay->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$waiting_for_pay->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$waiting_for_pay->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge badge_pinding">{{__('reservations.waiting_for_pay')}}</span>
                                </div>
                            </div>
{{--                            @if(time() < strtotime($waiting_for_pay->re_date_from))--}}
{{--                                <a data-href="{{route('reservation.reservationStatusOperation', $waiting_for_pay->id)}}" class="deleteButton cancel_reservation_button" type="button" data-toggle="modal" data-target="#confirmationModal">--}}
{{--                                    <i class="fas fa-times-circle"></i>--}}
{{--                                </a>--}}
{{--                            @endif--}}
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
            <div class="tab-pane fade" id="pills-expired" role="tabpanel" aria-labelledby="pills-expired-tab">
                @if(isset($reservations['finished']) && count($reservations['finished']))
                    @foreach($reservations['finished'] as $finished)
                        <div class="reservation_item">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$finished->id)}}">
                                        <img src="{{asset(json_decode($finished->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$finished->hall_name}}</b></h5>
                                        <span class="num">#{{$finished->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($finished->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$finished->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$finished->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge badge_expired">{{__('reservations.finished')}}</span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
            <div class="tab-pane fade" id="pills-canceled" role="tabpanel" aria-labelledby="pills-canceled-tab">
                @if(isset($reservations['canceled']) && count($reservations['canceled']))
                    @foreach($reservations['canceled'] as $canceled)
                        <div class="reservation_item">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$canceled->id)}}">
                                        <img src="{{asset(json_decode($canceled->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$canceled->hall_name}}</b></h5>
                                        <span class="num">#{{$canceled->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($canceled->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$canceled->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$canceled->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge badge_canceled">{{__('reservations.canceled')}}</span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
            <div class="tab-pane fade" id="pills-daily" role="tabpanel" aria-labelledby="pills-daily-tab">
                @if(count($dailyReservations))
                    @foreach($dailyReservations as $daily)
                        <div class="reservation_item">
                            <div class="row">
                                <div class="col-lg-3">
                                    <a href="{{route('reservation.reservationDetails',$daily->id)}}">
                                        <img src="{{asset(json_decode($daily->images)[0])}}" alt="" class="hall-img">
                                    </a>
                                </div>
                                <div class="col-lg-3">
                                    <div class="content">
                                        <h5 class="name mb-3"><b>{{$daily->hall_name}}</b></h5>
                                        <span class="num">#{{$daily->re_no}}</span>
                                        <p class="data mt-2 "><i class="far fa-calendar-alt"></i>{{date('d/m/Y', strtotime($daily->re_date_from))}}</p>
                                        <p class="data"><i class="far fa-user"></i> {{$daily->person_count}} {{__('members.persons')}} </p>
                                    </div>
                                </div>
                                <div class="col-lg-3">
                                    <h3 class="price center-vr dir-l"><b>{{$daily->total}}</b> <small>{{__('main.sar')}}</small></h3>
                                </div>
                                <div class="col-lg-3">
                                    <div class="prof-info">
                                        <img src="{{asset($user->photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                                        <h6 class="name mb-0">{{$user->name}}</h6>
                                    </div>
                                    <span class="badge badge_daily">{{__('reservations.daily')}}</span>
                                </div>
                            </div>
{{--                            @if(time() < strtotime($daily->re_date_from))--}}
{{--                                <a data-href="{{route('reservation.reservationStatusOperation', $daily->id)}}" class="deleteButton cancel_reservation_button" type="button" data-toggle="modal" data-target="#confirmationModal">--}}
{{--                                    <i class="fas fa-times-circle"></i>--}}
{{--                                </a>--}}
{{--                            @endif--}}
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-center text-danger no_data_alert">{{__('members.no_data')}}</div>
                @endif
            </div>
        </div>
    </div>
</div>
