@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
@endsection
@section('content')
    <section class="profile-pg profile-provider">
        <div class="container">
            <div class="row">
                <div class="col-lg-12 m-auto">
                    <div class="tab-content" id="v-pills-tabContent">
                        <div class="tab-pane fade show active" id="v-pills-tab6" role="tabpanel" aria-labelledby="v-pills-tab6-tab">
                            <div class="tab-wrapper addHall">
                                <div class="tab-content" id="nav-tabContent">
                                    <div class="row">
                                        <div class="col-md-9 m-auto">
                                            <div class="form-wrapper mt-5">
                                                <form class="form-row add_edit_hall_form" method="post" action="{{route('provider.AddEditHall', $myHall->id)}}" enctype="multipart/form-data">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <input name="name_{{$local}}" type="text" class="form-control" autocomplete="off" autofocus required value="{{$myHall->hall_name}}"/>
                                                            <label class="floating-label">{{__('halls.name')}}</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <select name="is_offer" class="form-control">
                                                                <option {{($myHall->is_offer ?? null) == 0 ? 'selected': ''}} value="0">{{__('halls.no')}}</option>
                                                                <option {{($myHall->is_offer ?? null) == 1 ? 'selected': ''}} value="1">{{__('halls.yes')}}</option>
                                                            </select>
                                                            <label class="floating-label">{{__('halls.is_offer') }} </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <select name="allow_services" class="form-control">
                                                                <option {{($myHall->allow_services ?? null) == 0 ? 'selected': ''}} value="0">{{__('halls.no')}}</option>
                                                                <option {{($myHall->allow_services ?? null) == 1 ? 'selected': ''}} value="1">{{__('halls.yes')}}</option>
                                                            </select>
                                                            <label class="floating-label">{{__('halls.allow_services') }} </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <select name="allow_requests" class="form-control">
                                                                <option {{($myHall->allow_requests ?? null) == 1 ? 'selected': ''}} value="1">{{__('halls.yes')}}</option>
                                                                <option {{($myHall->allow_requests ?? null) == 0 ? 'selected': ''}} value="0">{{__('halls.no')}}</option>
                                                            </select>
                                                            <label class="floating-label">{{__('halls.allow_requests') }} </label>
                                                        </div>
                                                    </div>
                                                    <!--<div class="col-md-12">-->
                                                    <!--    <div class="form-group">-->
                                                    <!--        <div class="input-images"></div>-->
                                                    <!--    </div>-->
                                                    <!--</div>-->

                                                    <!---------- new upload ---------->
                                                    <div class="col-md-12">
                                                        <div class="border_items text-center form-group">
                                                            <label class="upload_label" id="upload_label" for="files"> رفع صور القاعة </label>
                                                            <div class="upload_img_box">
                                                                @if($myHall->images)
                                                                    @foreach($myHall->images as $image)
                                                                    <div class="file-upload">
                                                                        <div class="file-select file-select-box">
                                                                            <div class="imagePreview" style="background: url({{asset($image)}});"></div>
                                                                            <input type="hidden" name="old_images[]" class="profileimg" value="{{$image}}">
                                                                        </div>
                                                                        <span class="cls"> <i class="fas fa-times-circle"></i> </span>
                                                                    </div>
                                                                    @endforeach
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!---------- end ---------->

                                                    <!--<div class="col-md-12 mb-4">-->
                                                    <!--    <div class="from-group d-flex justify-content-center flex-wrap">-->
                                                    <!--        @if($myHall->images)-->
                                                    <!--            @foreach($myHall->images as $image)-->
                                                    <!--                <img style="width:100px; margin: 10px" src="{{asset($image)}}" alt="">-->
                                                    <!--            @endforeach-->
                                                    <!--        @endif-->
                                                    <!--    </div>-->
                                                    <!--</div>-->
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <select name="reservation_way" class="form-control" autocomplete="off" autofocus required>
                                                                <option value="">{{__('halls.reservation_way') }}</option>
                                                                <option {{$myHall->reservation_way == 'direct' ? 'selected' : ''}} value="direct">{{__('halls.direct')}}</option>
                                                                <option {{$myHall->reservation_way == 'accept_request' ? 'selected' : ''}} value="accept_request">{{__('halls.accept_request')}}</option>
                                                            </select>
                                                            <label class="floating-label">{{__('halls.reservation_way') }} </label>

                                                        </div>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <select name="category_id" class="form-control">
                                                                <option value="">{{ __('halls.hall_category_id') }}</option>
                                                                @if(count($categories))
                                                                    @foreach($categories as $category)
                                                                        <option {{$myHall->category_id == $category->id ? 'selected': ''}} value="{{$category->id}}">{{$category->name}}</option>
                                                                    @endforeach
                                                                @endif
                                                            </select>
                                                            <label class="floating-label">{{__('halls.hall_category_id')}}</label>
                                                        </div>
                                                    </div>
                                                    <div class="card p-3 mb-3 col-lg-12">
                                                        <label>{{ __('halls.table_ids') }} </label>
                                                        <div class="row card-body">
                                                            @if(count($tables))
                                                                @foreach($tables as $table)
                                                                    <div class="col-md-4">
                                                                        <div class="custom-control custom-checkbox custom-control_3">
                                                                            <input {{in_array($table->id, ($myHall->table_ids ?? [])) ? 'checked' : ''}} type="checkbox" value="{{ $table->id }}" class="custom-control-input" id="person_table_ids_{{ $table->id }}" name="table_ids[]">
                                                                            <label class="custom-control-label" for="person_table_ids_{{ $table->id }}"> {{$table->name}}</label>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="card p-3 mb-3 col-lg-12">
                                                        <label>{{ __('halls.occasions') }} </label>
                                                        <div class="row card-body">
                                                            @if(count($occasions))
                                                                @foreach($occasions as $occasion)
                                                                    <div class="col-md-4">
                                                                        <div class="custom-control custom-checkbox custom-control_3">
                                                                            <input type="checkbox" {{ in_array($occasion->id, ($myHall->occasions ?? [])) ? 'checked' : '' }} value="{{ $occasion->id }}" class="custom-control-input" id="occasions_{{ $occasion->id }}" name="occasions[]">
                                                                            <label class="custom-control-label" for="occasions_{{ $occasion->id }}"> {{$occasion->name}}</label>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <input type="number" min="1" class="form-control" name="capacity" placeholder="{{ __('halls.capacity') }}" value='{{ $myHall->capacity ?? "" }}' autofocus required/>
                                                                <label class="floating-label">{{__('halls.capacity') }}</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <input type="number" min="1" class="form-control" name="total_capacity" placeholder="{{ __('halls.total_capacity') }}" value='{{ $myHall->total_capacity ?? "" }}'/>
                                                                <label class="floating-label">{{__('halls.total_capacity') }} </label>

                                                            </div>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <div class="form-group">
                                                                <input type="number" min="1" class="form-control" name="min_capacity" placeholder="{{ __('halls.min_capacity') }}" value='{{ $myHall->min_capacity ?? "" }}'/>
                                                                <label class="floating-label">{{ __('halls.min_capacity') }} </label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <select name="reservation_type" class="form-control">
                                                                    <option {{$myHall->reservation_type == 'person_count' ? 'selected' : ''}} value="person_count">{{__('halls.person_count')}}</option>
                                                                    <option {{$myHall->reservation_type == 'days_count' ? 'selected' : ''}} value="days_count">{{__('halls.days_count')}}</option>
                                                                </select>
                                                                <label class="floating-label">{{__('halls.reservation_type')}}</label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 booking_amount_per_person">
                                                            <div class="form-group">
                                                                <input type="number" min="1" class="form-control" name="booking_amount_per_person" placeholder="{{__('halls.booking_amount_per_person') }}" value='{{ $myHall->booking_amount_per_person ?? "" }}'/>
                                                                <label class="floating-label">{{ __('halls.booking_amount_per_person') }} </label>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 d-none booking_amount_per_day">
                                                            <div class="form-group">
                                                                <input type="number" min="1" class="form-control" name="booking_amount_per_day" placeholder="{{__('halls.booking_amount_per_day') }}" value='{{ $myHall->booking_amount_per_day ?? "" }}'/>
                                                                <label class="floating-label">{{ __('halls.booking_amount_per_day') }} </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="locForm">
                                                            <h5 class="loc_title"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="">{{__('halls.hall_location')}}</h5>
                                                            <div class="map-box mt-4 mb-4">
{{--                                                                <iframe width="100%" height="250" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=1%20Grafton%20Street,%20Dublin,%20Ireland+(My%20Business%20Name)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>--}}
                                                                <div style="border:0; height: 400px; width: 100%" class="map" id="map"></div>

                                                            </div>
                                                            <div class="row mt-1">

                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <select name="region_id" class="form-control">
                                                                            <option value="">{{ __('halls.region_id') }}</option>
                                                                            @if(count($regions))
                                                                                @foreach($regions as $region)
                                                                                    <option {{($myHall->region_id ?? null) == $region->id ? 'selected': ''}} value="{{$region->id}}">{{$region->name}}</option>
                                                                                @endforeach
                                                                            @endif
                                                                        </select>
                                                                        <label class="floating-label"> {{__('halls.region_id')}}</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <select name="city_id" class="form-control">
                                                                            <option value="">{{ __('halls.city_id') }}</option>
                                                                            @if(count($cities))
                                                                                @foreach($cities as $city)
                                                                                    <option {{($myHall->city_id ?? null) == $city->id ? 'selected': ''}} value="{{$city->id}}">{{$city->name}}</option>
                                                                                @endforeach
                                                                            @endif
                                                                        </select>
                                                                        <label class="floating-label"> {{ __('halls.city_id')}}</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <select name="sector_id" class="form-control">
                                                                            <option value="">{{ __('halls.sector_id') }}</option>
                                                                            @if(count($sectors))
                                                                                @foreach($sectors as $sector)
                                                                                    <option {{($myHall->sector_id ?? null) == $sector->id ? 'selected': ''}} value="{{$sector->id}}">{{$sector->name}}</option>
                                                                                @endforeach
                                                                            @endif
                                                                        </select>
                                                                        <label class="floating-label"> {{__('halls.sector_id')}}</label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <div class="form-group">
                                                                        <input type="text" class="form-control" name="street" placeholder="{{__('halls.street') }}" value='{{ $myHall->street ?? "" }}'/>
                                                                        <label class="floating-label">{{__('halls.street') }}</label>
                                                                        <input type="hidden" name="lat" value="{{$myHall->lat}}">
                                                                        <input type="hidden" name="lng" value="{{$myHall->lng}}">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="addService service_container">
                                                            <div class="deleted_service">
                                                                <div class="in-flex justify-content-between">
                                                                    <h5 class="loc_title mb-4">{{__('halls.added_services')}}</h5>
                                                                    <button class="addAnother btn add_service" type="button"><img src="{{asset('assets/web/images/icons/profile/add.svg')}}" alt=""></button>
                                                                </div>
                                                            </div>
                                                            @if(count($addedServices))
                                                                @foreach($addedServices as $addedService)
                                                                    <div class="deleted_service">
                                                                        <div class="in-flex justify-content-between">
{{--                                                                            @if($loop->iteration > 1)--}}
{{--                                                                                <a href="#" class="delete_service"><i class="fa fa-trash text-danger"></i></a>--}}
{{--                                                                            @endif--}}
                                                                            <a href="#" class="delete_service"><i class="fa fa-trash text-danger"></i></a>
                                                                            <h5 class="loc_title mb-4">{{__('halls.added_services')}}</h5>
                                                                            <button class="addAnother btn add_service" type="button"><img src="{{asset('assets/web/images/icons/profile/add.svg')}}" alt=""></button>
                                                                        </div>
                                                                        <div class="row mt-1">
                                                                            <div class="col-md-6">
                                                                                <div class="form-group">
                                                                                    <input name="added_services_name[]" type="text" class="form-control" autocomplete="off" autofocus required value="{{$addedService['name']}}"/>
                                                                                    <label class="floating-label">{{__('halls.added_services_name')}}</label>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <div class="form-group">
                                                                                    <input name="added_services_price[]" type="number" min="1" class="form-control" autocomplete="off" autofocus required value="{{$addedService['price']}}"/>
                                                                                    <label class="floating-label"> {{__('halls.added_services_price')}}</label>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <div class="form-group">
                                                                                    <textarea name="added_services_description[]" class="form-control" rows="2" autocomplete="off" autofocus required >{{$addedService['description']}}</textarea>
                                                                                    <label class="floating-label">{{__('halls.added_services_description')}}</label>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-12">
                                                                                <div class="border_items text-center form-group">
                                                                                    <label class="upload_added_service_image_label" id="person_upload_label" for="files">{{__('halls.upload_added_service_images')}}</label>
                                                                                    <div class="upload_img_box">
                                                                                        @if($addedService['image'] ?? null)
                                                                                        <div class="file-upload">
                                                                                            <div class="file-select file-select-box">
                                                                                                <div class="imagePreview" style="background: url({{asset($addedService['image'])}});"></div>
                                                                                                <input type="hidden" name="old_added_services_image[]" value="{{$addedService['image']}}">
                                                                                                <input type="file" name="added_services_image[]" class="profileimg">
                                                                                            </div>
                                                                                            <span class="cls"> <i class="fas fa-times-circle"></i> </span>
                                                                                        </div>
                                                                                        @endif
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                    </div>
                                                    {{-- Dates range --}}
                                                    <div class="card col-lg-12 p-3 mb-3">
                                                        <label>{{__('halls.dates_rang') }} </label>
                                                        <div class="row justify-content-start align-items-center align-content-center">
                                                            <div class="form-group col-md-6">
                                                                <input type="text" placeholder="{{ __('halls.dates_rang_from') }}" name="dates_rang_from" value="{{$myHall->available_dates['dates_rang_from']}}" class="datepicker form-control">
                                                            </div>
                                                            <div class="form-group col-md-6">
                                                                <input type="text" placeholder="{{ __('halls.dates_rang_to') }}" name="dates_rang_to" value="{{$myHall->available_dates['dates_rang_to']}}" class="datepicker form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{-- UnAvailable dates block--}}
                                                    <div class="card col-lg-12 p-3 mb-3">
                                                        <label>{{__('halls.unavailable_dates') }} </label>
                                                        <div class="unavailable_dates_container_person">
                                                            @if(count($myHall->unavailable_dates))
                                                                @foreach($myHall->unavailable_dates as $unAvailableDate)
                                                                    <div class="row justify-content-start align-items-center align-content-center unavailable_date_item">
                                                                        <div class="form-group col-md-2">
                                                                            <a class="btn btn-danger delete_unavailable_date_link" href="#"><i class="fa fa-times"></i></a>
                                                                        </div>
                                                                        <div class="form-group col-md-5">
                                                                            <input type="text" placeholder="{{ __('halls.unavailable_dates_from') }}" name="unavailable_dates_from[]" value="{{$unAvailableDate[0]}}" class="datepicker form-control">
                                                                        </div>
                                                                        <div class="form-group col-md-5">
                                                                            <input type="text" placeholder="{{ __('halls.unavailable_dates_to') }}" name="unavailable_dates_to[]" value="{{last($unAvailableDate)}}" class="datepicker form-control">
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <a data-target=".unavailable_dates_container_person" href="#" class="btn btn-primary btn-sm btn-block add_unavailable_dates_link"><i class="fa fa-plus"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    {{-- Discount dates block--}}
                                                    <div class="card col-lg-12 p-3 mb-3">
                                                        <label>{{ __('halls.discount_dates') }}</label>
                                                        <div class="discount_dates_container_person">
                                                            @if(count($myHall->discount_dates))
                                                                @foreach($myHall->discount_dates as $discountDates)
                                                                    <div class="row align-items-center discount_date_item">
                                                                        <div class="form-group col-md-1">
                                                                            <a class="btn btn-danger delete_discount_date_link" href="#"><i class="fa fa-times"></i></a>
                                                                        </div>
                                                                        <div class="form-group col-md-3">
                                                                            <input type="text" placeholder="{{ __('halls.discount_dates_from') }}" name="discount_dates_from[]" value="{{$discountDates['dates'][0]}}" class="discount_dates datepicker discount_dates_from form-control">
                                                                        </div>
                                                                        <div class="form-group col-md-3">
                                                                            <input type="text" placeholder="{{ __('halls.discount_dates_to') }}" name="discount_dates_to[]" value="{{last($discountDates['dates'])}}" class="discount_dates datepicker discount_dates_to form-control">
                                                                        </div>
                                                                        <div class="form-group col-md-5">
                                                                            <div class="custom-control custom-checkbox">
                                                                                <div class="discount_dates_container d-flex justify-content-start align-content-center align-items-center custom-control_3">
                                                                                    <input name="discount_percentage[]" type="number" min="1" pattern="/[1-9]/" class="discount_percentage col-md-8 form-control" placeholder="{{__('halls.discount_percentage')}}" value="{{$discountDates['discount_percentage']}}">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    </div>
                                                                @endforeach
                                                            @endif
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <a data-target=".discount_dates_container_person" href="#" class="btn btn-primary btn-sm btn-block add_discount_dates_link"><i class="fa fa-plus"></i></a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                   <div class="col-md-12">
                                                       <div class="form-group">
                                                           <textarea name="description_{{$local}}" class="form-control" rows="7" autocomplete="off" autofocus required >{{$myHall->hall_description}}</textarea>
                                                           <label class="floating-label">{{__('halls.description')}}</label>
                                                       </div>
                                                   </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <textarea name="reservation_condition_{{$local}}" class="form-control" rows="7" autocomplete="off" autofocus >{{$myHall->reservation_condition}}</textarea>
                                                            <label class="floating-label"> {{__('halls.reservation_condition')}} </label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <textarea name="features_{{$local}}" class="form-control" rows="7" autocomplete="off" autofocus >{{$myHall->features}}</textarea>
                                                            <label class="floating-label"> {{__('halls.features')}} </label>
                                                        </div>
                                                    </div>
                                                    <button class="submit-butn mt-4 add_edit_hall_button" type="submit"> {{__('members.save')}}</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@section('inner_js')
{{--    <script src="{{ asset('assets/admin/js/lib/jquery-ui.js') }}"></script>--}}

    <script>
        let getCityAndSectorRoute = "{{route('provider.getCityAndSector')}}",
            addServiceIcon = "{{asset('assets/web/images/icons/profile/add.svg')}}",
            region_name = "{{__('members.region_id')}}",
            city_name = "{{__('members.city_id')}}",
            sector_name = "{{__('members.sector_id')}}",
            unavailable_dates_to = "{{__('halls.unavailable_dates_to')}}",
            unavailable_dates_from = "{{__('halls.unavailable_dates_from')}}",
            discount_dates_to = "{{__('halls.discount_dates_to')}}",
            discount = "{{__('halls.discount')}}",
            discount_dates_from = "{{__('halls.discount_dates_from')}}",
            discount_dates = "{{__('halls.discount_dates')}}",
            discount_percentage = "{{__('halls.discount_percentage')}}",
            added_services = "{{__('halls.added_services')}}",
            added_services_name = "{{__('halls.added_services_name')}}",
            added_services_price = "{{__('halls.added_services_price')}}",
            added_services_description = "{{__('halls.added_services_description')}}",
            added_services_image = "{{__('halls.added_services_image')}}",
            upload_added_service_images = "{{__('halls.upload_added_service_images')}}",
            select = "{{__('members.select')}}",
            upload_hall_image = "{{__('halls.upload_hall_image')}}",
            latitude = "{{$myHall->lat}}",
            longitude = "{{$myHall->lng}}",
            inputName = 'images[]';
    </script>
    <script src="{{ asset('assets/web/js/provider.edit_hall.js') }}"></script>
    <script src="{{ asset('assets/web/js/image_upload.js') }}"></script>
    <script src="https://polyfill.io/v3/polyfill.min.js?features=default"></script>
    <script defer src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDpVcBEVHKN5-iO0-z5MoEeLLpfV18JZjg&callback=initMap"></script>


    <script>

        function initMap() {
            /** Map one block */
            let map = new google.maps.Map(document.getElementById("map"), {
                zoom: 6,
                center: { lat: parseFloat(latitude) , lng: parseFloat(longitude) }
            });

            let marker = new google.maps.Marker({
                map: map,
                draggable: true,
                animation: google.maps.Animation.DROP,
                position: { lat: parseFloat(latitude) , lng: parseFloat(longitude) }
            });

            marker.addListener("dragend", function (map) {
                let lat = map.latLng.lat(), lng = map.latLng.lng();
                localStorage.setItem('lat', lat);
                localStorage.setItem('lng', lng);
                $('input[name="lat"]').val(lat);
                $('input[name="lng"]').val(lng);
                var geocoder = new google.maps.Geocoder();
                var infowindow = new google.maps.InfoWindow();

                google.maps.event.addListener(marker, 'dragend', function() {
                    infowindow.close();
                });

                var latlng = { lat: parseFloat(lat), lng: parseFloat(lng) };
                geocoder.geocode({ location: latlng }, function(results, status) {
                    if (status === "OK") {
                        if (results[0]) {
                            infowindow.setContent(results[0].formatted_address);
                            infowindow.open(map, marker);
                            $('input[name="street"]').val(results[0].formatted_address);
                        } else {
                            window.alert("No results found");
                        }
                    } else {
                        window.alert("Geocoder failed due to: " + status);
                    }
                });
                if (marker.getAnimation() !== null) {
                    marker.setAnimation(null);
                } else {
                    marker.setAnimation(google.maps.Animation.BOUNCE);
                }
            });
        }
    </script>



@endsection
