@extends('web.layouts.container')
@section('css')
    <link rel="stylesheet" href="{{ asset('assets/web/css/lib/toastr.css') }}" />
@endsection
@section('content')
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{__('main.sign_in')}}</li>
                </ol>
                <h3>{{__('main.sign_in')}}</h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="register-pg">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6 pr-0 pl-0">
                    <img src="{{asset('assets/web/images/header-img.png')}}" alt="" class="main-img">
                </div>
                <div class="col-md-6 pr-0 pl-0">
                    <div class="text-box center-vr">
                        <h6 class="h6">{{__('main.welcome_you_again')}}</h6>
                        <h4 class="h4"> {{__('main.registration')}} <b> {{__('main.enter')}}</b></h4>
                        <p class="p">{{__('main.login_hint')}}</p>
                        <div class="form-wrapper mt-5">
                            <form method="post" action="{{route('userProvider.doLogin')}}" class="login_form">
                                <div class="form-group">
                                    <input name="email" type="email" class="form-control" autocomplete="off" autofocus required />
                                    <label class="floating-label">  {{__('users.email')}} </label>
                                </div>
                                <div class="form-group">
                                    <input name="password" type="password" class="form-control" id="password" autocomplete="off" autofocus required />
                                    <label class="floating-label"> {{__('users.password')}} </label>
                                    <span class="togglePassword"><i class="far fa-eye" id="togglePassword"></i></span>
                                </div>
                                <a class="forget-link" href="{{route('user.forgetPassword')}}">{{__('main.forget_password')}}</a>
                                <button class="submit-butn login_button">{{__('main.sign_in')}}</button>

                                <p class="another_choice mt-4">{{__('main.no_account')}} <a href="{{route('user.register')}}">{{__('main.sign_up')}}</a></p>
                            </form>
                        </div>
                    </div>

                </div>
            </div>

        </div>
    </section>
@endsection

@section('inner_js')
    <script src="{{ asset('assets/web/js/lib/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/web/js/users.login.js') }}"></script>
@endsection
