@if($settings['whatsapp'] ?? null)
<a target="_blank" href="https://api.whatsapp.com/send?phone={{$settings['whatsapp']}}&text=" class="whatsapp_butn">
    <img src="{{asset('assets/web/images/icons/whatsapp-icon.png')}}" alt="">
</a>
@endif
<footer>
    <div class="container">
        <div class="row">
            <div class="col-lg-3 order-1 order-lg-0">
                <div class="content">
                    <h5> {{__('visitorMessages.head')}} </h5>
                    <a href="#" class="text-white d-block mb-3">
                        <i class="fas fa-map-marker-alt mx-2"></i>
                        <span> {{$settings['site_address']}} </span>
                    </a>
                    <a href="#" class="text-white d-block mb-3">
                        <i class="far fa-envelope mx-2"></i>
                        <span> {{$settings['site_email']}} </span>
                    </a>
                    <a href="#" class="text-white d-block mb-3">
                        <i class="fas fa-phone mx-2"></i>
                        <span> {{$settings['site_phone']}} </span>
                    </a>
                    <div class="social-links">
                        <a target="_blank" href="{{isset($settings['facebook']) ? $settings['facebook'] : ''}}">
                            <img src="{{asset('assets/web/images/icons/facebook.svg')}}" alt="">
                        </a>
                        <a target="_blank" href="{{isset($settings['instagram']) ? $settings['instagram'] : ''}}">
                            <img src="{{asset('assets/web/images/icons/instagram.svg')}}" alt="">
                        </a>
                        <a target="_blank" href="{{isset($settings['twitter']) ? $settings['twitter'] : ''}}">
                            <img src="{{asset('assets/web/images/icons/twitter.svg')}}" alt="">                    </a>
                        <a href="tel::{{isset($settings['whatsapp']) ? $settings['whatsapp'] : ''}}">
                            <img src="{{asset('assets/web/images/icons/whatsapp.svg')}}" class="white" alt="">
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-6 order-0 mb-5 mb-lg-0">
                <div class="content">
                    <img src="{{asset('assets/web/images/logo-footer.svg')}}" alt="" class="logo">
                    <img src="{{asset('assets/web/images/pattern-footer.svg')}}" class="pattern" alt="">
                    <div class="text text-white text-center mt-4">{{wordLimit(stripText(getAbout()->description), 54)}}</div>
                    <div class="pay_imgs">
                        <div class="img">
                            <img src="{{asset('assets/web/images/pay/visa.png')}}" alt="">
                        </div>
                        <div class="img">
                            <img src="{{asset('assets/web/images/pay/master.png')}}" alt="">                  
                        </div>
                        <div class="img">
                            <img src="{{asset('assets/web/images/pay/mada.png')}}" alt="">
                        </div>
                        <div class="img">
                            <img src="{{asset('assets/web/images/pay/apple-pay2.png')}}" alt="">
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3">
                <div class="content">
                    <h5>{{__('main.important_links')}}</h5>
                    <div class="social-links links">
                        <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('aboutUs'), [], true)}}">{{__('abouts.head')}}</a>
                        {{--                        <a href="#">{{__('main.services')}}</a>--}}
                        <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('contactUs'), [], true)}}">{{__('visitorMessages.head')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('privacyPolicy'), [], true)}}">{{__('policies.privacy_policy')}}</a>
                        <a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('termsConditions'), [], true)}}">{{__('policies.terms_conditions')}}</a>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <div class="copyright">
        <p> {{__('main.copy_right')}} <span>{{date('Y')}}</span> {!! __('main.alyomhost_designed') !!} </p>
    </div>
</footer>
<a data-scroll href="#" class="scroll-top-btn" id="scroll-btn"><i class="fas fa-level-up-alt"></i></a>

<!-- Modal -->
<div class="modal fade buy_now_modal" id="buy_now_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-body">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <div class="product_content_modal_body"></div>
            </div>
        </div>
    </div>
</div>

