@extends('web.layouts.container')

@section('content')
    <div class="searching">
        <div class="container-fluid">
            <div class="inner">
                <form action="{{route('hall.offerHall')}}" method="get" class="form search_form" autocomplete="off">
                    <input type="hidden" value="true" name="hall_offer">
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/selectbox-4.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="occasion_id" class="form-control search-select">
                                <option value="">{{__('main.your_occasion')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                @if(count($occasions))
                                    @foreach($occasions as $occasion)
                                        <option value="{{$occasion->id}}">{{$occasion->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-2.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="category_id" class="form-control search-select">
                                <option value="">{{__('main.type_of_place')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                {{--                                <option value="">{{__('halls.all_categories')}}</option>--}}
                                @if(count($categories))
                                    @foreach($categories as $category)
                                        <option value="{{$category->id}}">{{$category->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-3.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="city_id" class="form-control search-select">
                                <option value="">{{__('main.city')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                @if(count($cities))
                                    @foreach($cities as $city)
                                        <option value="{{$city->id}}">{{$city->name}}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-6.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select name="rate" class="form-control search-select">
                                <option value="">{{__('main.evaluate_stars')}}</option>
                                <option value="all">{{__('halls.all')}}</option>
                                <option value="5">5.0</option>
                                <option value="4">4.0</option>
                                <option value="3">3.0 </option>
                            </select>
                        </div>
                    </div>
                    <div class="item">
                        <img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" class="icon" alt="">
                        <div class="form-group">
                            <select class="form-control search-select period_days">
                                <option selected >{{__('main.period')}}</option>
                                <option value="multi">{{__('main.several_days')}}</option>
                                <option value="single">{{__('main.one_day')}}</option>
                            </select>
                        </div>
                    </div>

                    <div class="dateBordering">
                        <div class="item dateItem">
                            <div class="form-group">
                                <label>{{__('main.from')}}</label>
                                <span class="icon"><img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" alt=""></span>
                                <input name="re_date_from" class="datepicker form-control" data-date-format="mm/dd/yyyy" placeholder="MM/DD/YYYY">
                            </div>
                        </div>
                        <div class="item dateItem date_to">
                            <div class="form-group">
                                <label>{{__('main.to')}}</label>
                                <span class="icon"><img src="{{asset('assets/web/images/icons/advances-search-5.svg')}}" alt=""></span>
                                <input name="re_date_to" class="datepicker form-control" data-date-format="mm/dd/yyyy" placeholder="MM/DD/YYYY">

                            </div>
                        </div>
                    </div>

                    <button class="submit-btn"><img src="{{asset('assets/web/images/icons/advances-search-4.svg')}}" class="icon" alt=""> </button>

                </form>
            </div>

        </div>
    </div>
    <section class="page-heading">
        <div class="container">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{LaravelLocalization::getLocalizedURL(getCurrentLocale(), route('home'), [], true)}}">{{__('main.home')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page"> {{__('halls.special_offer')}} </li>
                </ol>
                <h3> {{__('halls.special_offer')}} </h3>
            </nav>
        </div>
        <img src="{{asset('assets/web/images/page-heading-1.png')}}" alt="" class="pattern1">
        <img src="{{asset('assets/web/images/page-heading-2.png')}}" alt="" class="pattern2">
        <img src="{{asset('assets/web/images/page-heading-3.png')}}" alt="" class="pattern3">
    </section>
    <section class="halls-sec">
        <div class="container">
            <div class="row halls_container">
                @if(count($halls))
                    @foreach($halls as $hall)
                        <div class="col-md-6 col-lg-4">
                            <div class="hall-card">
                                <div class="img-box">
                                    <a href="{{route('hall.show', $hall->id)}}">
                                        <img src="{{getPhotoThumb($hall->images[0])}}" alt="">
                                        @if($hall->rate)
                                            <span class="rate-badge"><i class="far fa-star"></i> {{$hall->rate}}</span>
                                        @endif
                                        <span class="badge">{{$hall->category_name}}</span>
                                    </a>
                                </div>
                                <div class="card-body">
                                    <div class="prof-info">
                                        <img src="{{asset($hall->provider_logo)}}" alt="" class="prof_img">
                                        <div class="text">
                                            <span class="provider">{{__('main.provider')}}</span>
                                            <h6 class="name mb-0">{{$hall->provider_name}}</h6>
                                        </div>
                                    </div>
                                    <h5 class="headline">{{$hall->hall_name}}</h5>
                                    <p class="city-name"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{$hall->city_name}}</p>
                                    @if($hall->reservation_type == 'person_count')
                                        <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_person}} {{__('main.sar')}}</b></span>
                                        {{(__('main.per_person'))}}
                                    @endif
                                    @if($hall->reservation_type == 'days_count')
                                        <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_day}} {{__('main.sar')}}</b></span>
                                        {{(__('main.per_day'))}}
                                    @endif
                                    <a href="{{route('reservation.hallReservation', $hall->id)}}" class="link-btn my-3"> {{__('main.book_now')}}  </a>
                                </div>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="alert alert-secondary text-danger text-center col-md-12">{{__('members.no_data')}}</div>
                @endif
            </div>
            @if(count($halls) > 8) <button class="butn load_more_button">{{__('main.load_more')}}</button>  @endif

        </div>
    </section>
@endsection

@section('inner_js')

    <script>
        let skip = 0;
        $('.load_more_button').click(async function (e) {
            e.preventDefault();
            let url = window.location.href;

            // $(this).prop('disabled', true);

            skip = skip + 9;

            let data = {skip: skip};


            const response= await ajax({
                url,
                data,
                dataType: 'html',
                method: 'get'
            });

            if (response){
                if (response.search('show_done') > -1){
                    $(this).remove();
                }
                $('.halls_container').append(response);
            }

        });
    </script>
@endsection

