<div class="row">
    @if(count($halls))
        @foreach($halls as $hall)
            <div class="col-md-6 col-lg-4">
                <div class="hall-card">
                    <div class="img-box">
                        <a href="{{route('hall.show', $hall->id)}}">
                            <img src="{{asset($hall->images[0])}}" alt="">
                            @if($hall->rate)
                                <span class="rate-badge"><i class="far fa-star"></i> {{$hall->rate}}</span>
                            @endif
                            <span class="badge">{{$hall->category_name}}</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="prof-info">
                            <img src="{{asset($hall->provider_photo ?? 'assets/web/images/avatar.png')}}" alt="" class="prof_img">
                            <div class="text">
                                <span class="provider">{{__('main.provider')}}</span>
                                <h6 class="name mb-0">{{$hall->provider_name}}</h6>
                            </div>
                        </div>
                        <h5 class="headline">{{$hall->hall_name}}</h5>
                        <p class="city-name"><img src="{{asset('assets/web/images/icons/loc-blue.svg')}}" alt="" class="icon"> {{$hall->city_name}}</p>
                        @if($hall->reservation_type == 'person_count')
                            <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_person}} {{__('main.sar')}}</b></span>
                            {{(__('main.per_person'))}}
                        @endif
                        @if($hall->reservation_type == 'days_count')
                            <p class="price">{{__('main.start_from')}} <span class="dir-l"><b>{{$hall->booking_amount_per_day}} {{__('main.sar')}}</b></span>
                                {{(__('main.per_day'))}}
                                @endif
                                <a href="{{route('reservation.hallReservation', $hall->id)}}" class="link-btn my-3"> {{__('main.book_now')}}  </a>
                    </div>
                </div>
            </div>
        @endforeach
        {{$halls->links('web.halls.pagination.paginate', ['paginator' => $halls])}}
        {{--                    {{$halls->links('web.halls.pagination.default', ['paginator' => $halls])}}--}}
        {{--                    {{$halls->links()}}--}}
    @else
        <div class="alert alert-secondary text-danger text-center col-md-12">{{__('members.no_data')}}</div>
    @endif
</div>
